#include "snsBME280.h"

snsBME280::snsBME280(I2C *_i2c,char _addr7)
{
    addr8 = _addr7<<1;
    pI2C = _i2c;
    init();
}

snsBME280::~snsBME280()
{
    
}

void snsBME280::measure(float *_t,float *_p,float *_h)
{
    BME280_S32_t hum_raw,temp_raw,pres_raw;
    char cmd[2];
    char data[8];
    
    cmd[0] = 0xf7;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,8);
    
    pres_raw = (data[0] << 12) | (data[1] << 4) | (data[2] >> 4);
    temp_raw = (data[3] << 12) | (data[4] << 4) | (data[5] >> 4);
    hum_raw  = (data[6] << 8) | data[7];

    *_t = BME280_compensate_T_int32(temp_raw)*0.01f; //in degC
    *_p = BME280_compensate_P_int64(pres_raw)/25600.0f; //in hPa
    *_h = BME280_compensate_H_int32(hum_raw)/1024.0f; //in %
}

void snsBME280::init()
{
    char cmd[2];
    char data[24];

    //config
    unsigned char osrs_t = 1;             //Temperature oversampling x 1
    unsigned char osrs_p = 1;             //Pressure oversampling x 1
    unsigned char osrs_h = 1;             //Humidity oversampling x 1
    unsigned char mode = 3;               //Normal mode
    unsigned char t_sb = 5;               //Tstandby 1000ms
    unsigned char filter = 0;             //Filter off 
    unsigned char spi3w_en = 0;           //3-wire SPI Disable
    
    unsigned char ctrl_meas_reg = (osrs_t << 5) | (osrs_p << 2) | mode;
    unsigned char config_reg    = (t_sb << 5) | (filter << 2) | spi3w_en;
    unsigned char ctrl_hum_reg  = osrs_h;

    cmd[0] = 0xf2;
    cmd[1] = ctrl_hum_reg;
    pI2C->write(addr8,cmd,2);
    cmd[0] = 0xf4;
    cmd[1] = ctrl_meas_reg;
    pI2C->write(addr8,cmd,2);
    cmd[0] = 0xf5;
    cmd[1] = config_reg;
    pI2C->write(addr8,cmd,2);

    //get dig data
    cmd[0] = 0x88;
    pI2C->write(addr8,cmd,1);
    wait(0.1);
    pI2C->read(addr8,data,24);
    dig_T1 = (data[1] << 8) | data[0];
    dig_T2 = (data[3] << 8) | data[2];
    dig_T3 = (data[5] << 8) | data[4];
    dig_P1 = (data[7] << 8) | data[6];
    dig_P2 = (data[9] << 8) | data[8];
    dig_P3 = (data[11] << 8) | data[10];
    dig_P4 = (data[13] << 8) | data[12];
    dig_P5 = (data[15] << 8) | data[14];
    dig_P6 = (data[17] << 8) | data[16];
    dig_P7 = (data[19] << 8) | data[18];
    dig_P8 = (data[21] << 8) | data[20];
    dig_P9 = (data[23] << 8) | data[22];

    cmd[0] = 0xA1;
    wait(0.1);
    pI2C->write(addr8,cmd,1);
    wait(0.1);
    pI2C->read(addr8,data,1);
    dig_H1 = data[0];
    
    cmd[0] = 0xE1;
    wait(0.1);
    pI2C->write(addr8,cmd,1);
    wait(0.1);
    pI2C->read(addr8,data,7);
    dig_H2 = (data[1] << 8) | data[0];
    dig_H3 = data[2];
    dig_H4 = (data[3] << 4) | (data[4] & 0x0f);
    dig_H5 = (data[5] << 4) | ((data[4] >> 4) & 0x0f);
    dig_H6 = data[6];
    
    //start measuring  
    cmd[0] = 0xf4;
    cmd[1] = 0b00100111;
    pI2C->write(addr8, cmd, 2);
    
}


// ****followings are written by BOSCH and modified by JSF****

// Returns temperature in DegC, resolution is 0.01 DegC. Output value of “5123” equals 51.23 DegC.
// t_fine carries fine temperature as global value

BME280_S32_t snsBME280::BME280_compensate_T_int32(BME280_S32_t adc_T)
{

    BME280_S32_t var1, var2, T;
    var1 = (((adc_T>>3)-((BME280_S32_t)dig_T1<<1))*((BME280_S32_t)dig_T2))>>11;
    var2 = (((((adc_T>>4)-((BME280_S32_t)dig_T1))*((adc_T>>4)-((BME280_S32_t)dig_T1)))>>12) * ((BME280_S32_t)dig_T3))>>14;
    t_fine = var1 + var2;
    T = (t_fine * 5 + 128) >> 8;
    return T;
}

// Returns pressure in Pa as unsigned 32 bit integer in Q24.8 format (24 integer bits and 8 fractional bits).
// Output value of “24674867” represents 24674867/256 = 96386.2 Pa = 963.862 hPa
BME280_U32_t snsBME280::BME280_compensate_P_int64(BME280_S32_t adc_P)
{
    BME280_S64_t var1, var2, p;
    var1 = ((BME280_S64_t)t_fine)-128000;
    var2 = var1 * var1 * (BME280_S64_t)dig_P6;
    var2 = var2 + ((var1*(BME280_S64_t)dig_P5)<<17);
    var2 = var2 + (((BME280_S64_t)dig_P4)<<35);
    var1 = ((var1 * var1 * (BME280_S64_t)dig_P3)>>8) + ((var1 * (BME280_S64_t)dig_P2)<<12);
    var1 = (((((BME280_S64_t)1)<<47)+var1))*((BME280_S64_t)dig_P1)>>33;
    if (var1 == 0)
    {
        return 0; // avoid exception caused by division by zero
    }
    p = 1048576-adc_P;
    p = (((p<<31)-var2)*3125)/var1;
    var1 = (((BME280_S64_t)dig_P9) * (p>>13) * (p>>13)) >> 25;
    var2 = (((BME280_S64_t)dig_P8) * p) >> 19;
    p = ((p + var1 + var2) >> 8) + (((BME280_S64_t)dig_P7)<<4);
    return (BME280_U32_t)p;
}

// Returns humidity in %RH as unsigned 32 bit integer in Q22.10 format (22 integer and 10 fractional bits).
// Output value of “47445” represents 47445/1024 = 46.333 %RH
BME280_U32_t snsBME280::BME280_compensate_H_int32(BME280_S32_t adc_H)
{
    BME280_S32_t v_x1_u32r;
    v_x1_u32r = (t_fine - ((BME280_S32_t)76800));
    v_x1_u32r = (((((adc_H << 14) - (((BME280_S32_t)dig_H4) << 20) - (((BME280_S32_t)dig_H5) * v_x1_u32r)) +
                ((BME280_S32_t)16384)) >> 15) * (((((((v_x1_u32r * ((BME280_S32_t)dig_H6)) >> 10) * (((v_x1_u32r *
                ((BME280_S32_t)dig_H3)) >> 11) + ((BME280_S32_t)32768))) >> 10) + ((BME280_S32_t)2097152)) *
                ((BME280_S32_t)dig_H2) + 8192) >> 14));
            
    v_x1_u32r = (v_x1_u32r-(((((v_x1_u32r>>15)*(v_x1_u32r>>15) )>>7)*((BME280_S32_t)dig_H1))>>4));
    v_x1_u32r = (v_x1_u32r < 0 ? 0 : v_x1_u32r);
    v_x1_u32r = (v_x1_u32r > 419430400 ? 419430400 : v_x1_u32r);
    return (BME280_U32_t)(v_x1_u32r>>12);
}
