#include "ACS712.h"
#include "mbed.h"

// Constructor/Destructor
ACS712::ACS712(PinName const outpin) 
    
    : 
    
    _aInPin(new AnalogIn(outpin))
    
{}

ACS712::~ACS712()
{
    delete _aInPin;
}

// ----- Public Methods -----

void ACS712::init() 
{

}
double ACS712::read_current_sensor()
{    
    double val;
    val = _aInPin->read();
    val *= val;
    val = sqrt(val);
    return val;
}

int ACS712::read_ain_uint_16()
{
    int val = 0;
    
    val = _aInPin->read_u16();
    
    return val;
}

void ACS712::convert_to_amps(float acs_offset, float gain, int type)
{   
    
    double _current_in = read_current_sensor()*3.3;
    
    switch(type) {
        
        case 5:
        _current = (acs_offset*gain - _current_in*gain)/.185*gain;    
        break;
        case 20:
        _current = (acs_offset*gain - _current_in*gain)/.100*gain;    
        break;
        case 30:
        _current = (_current_in*gain - acs_offset*gain)/.066*gain; 
        break;
        default:
        _current = 999.9;
        break;
        
        }
    
}


bool ACS712::over_current_detection(double operating_current)
{    

    bool current_spike_flag = false;
    
    if(_current > (1.1*operating_current)) {
        
        current_spike_flag = true;
        
        }
    else {
        
        current_spike_flag = false;
        
        }
    
    return current_spike_flag;

}

float ACS712::get_current_amps()    
{
    
    return _current;
    
}
