#ifndef ACS712_H
#define ACS712_H

#define WAIT 5.0
#include "mbed.h"

/**
    @file   ACS712.h
*   @brief  Library for interfacing ACS712 Hall Effect Current sensor
*
*   @author Josh Marshall
*
*   @date   July 2019
*/


namespace mbed
{
 class   AnalogIn; 
}

class ACS712 
{
    
private:

    mbed::AnalogIn *_aInPin;

public:
    
    /** Constructor */
    ACS712(PinName const outpin);

    /** Destructor */
    ~ACS712();

/** 
*   Initialise all peripherals and configure interrupts 
*   @author Josh Marshall
*   @date   July 2019
*/
void init();


/** 
*   Reads current sensor
*   @returns current sensor value in range 0.0 to 1.0
*   @author Josh Marshall
*   @date   July 2019
*/
double read_current_sensor();


/** 
*   Read current sensor
*   @returns current sensor value in range 0 to 65535 (2^16-1)
*            K64F High‐speed 16‐bit ADC with configurable resolution
*            LPC1768 12-bit Analog-to-Digital Converter (ADC) with input multiplexing among
*            eight pins, conversion rates up to 200 kHz, and multiple result registers. 
*   @author  Josh Marshall
*   @date    July 2019
*/


int read_ain_uint_16();

/** 
*   Read current sensor and convert to amps
*   @param  acs_ffset the value that the current sensor outputs at 0 amps
*   @param  gain from potential divider to map 5v out put of sensor onto 3.3v input
*   @param  sensor type 5,20, or 30 amp 
*   @author Josh Marshall
*   @date   July 2019
*/
void convert_to_amps(float acs_offset, float gain, int type);

/** 
*   If current spike (>1.1*operating current) from motor is detected it returns true flag
*   @param  value of current from ACS712 Hall Effect Current Sensor
*   @prarm  typical operating current
*   @author Josh Marshall
*   @date   July 2019
*/

bool over_current_detection(double operating_current);

/**
*   Returns the value frrom the current sensor
*   @author Josh Marshall
*   @date   July 2019
*/

float get_current_amps();
 
private:
           
    double _current;
    
};

#endif