#include "mbed.h"
#include "tactile_mouse.hpp"
#include "taxel.hpp"

taxel::taxel(){
    steps=0;
    targetSteps=0;
    lastStep=1;
    delay = 0.003;
    changed = false;
}

taxel::taxel(int x_, int y_){
    x=x_;
    y=y_;
    steps=0;
    targetSteps=0;
    lastStep=1;
    delay = 0.003;
    changed = false;
}

taxel::~taxel(){}

void taxel::step1(){
    MotorA1=1;
    MotorA2=0;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    lastStep = 1;
    }

void taxel::step2(){
    MotorA1=1;
    MotorA2=0;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    lastStep = 2;
    }

void taxel::step3(){
    MotorA1=0;
    MotorA2=1;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    lastStep = 3;
    }

void taxel::step4(){
    MotorA1=0;
    MotorA2=1;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    lastStep = 4;
    }
    
    
void taxel::stop(){
    MotorA1=0;
    MotorA2=0;
    MotorB1=0;
    MotorB2=0;
    step = 1;
    step=0;
    }
    
//Extend and retract functions take time delay in S
void taxel::down(){
    step4();
    step3();
    step2();
    step1();
    stop();
}
    
void taxel::up(){
    step1();
    step2();
    step3();
    step4();
    stop();
}
    
void taxel::selectMotor(int x, int y){
    switch (x){
        case 0: BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
        case 1: BOARD_MUXA=1;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
        case 2: BOARD_MUXA=0;
                BOARD_MUXB=1;
                BOARD_MUXC=0;
                break;
        case 3: BOARD_MUXA=1;
                BOARD_MUXB=1;
                BOARD_MUXC=0;
                break;
        case 4: BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=1;
                break;
        case 5: BOARD_MUXA=1;
                BOARD_MUXB=0;
                BOARD_MUXC=1;
                break;
        case 6: BOARD_MUXA=0;
                BOARD_MUXB=1;
                BOARD_MUXC=1;
                break;
        case 7: BOARD_MUXA=1;
                BOARD_MUXB=1;
                BOARD_MUXC=1;
                break;
        default:BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
    }
    switch (y){
        case 0: MUXA=0;
                MUXB=0;
                MUXC=0;
                break;
        case 1: MUXA=1;
                MUXB=0;
                MUXC=0;
                break;
        case 2: MUXA=0;
                MUXB=1;
                MUXC=0;
                break;
        case 3: MUXA=1;
                MUXB=1;
                MUXC=0;
                break;
        case 4: MUXA=0;
                MUXB=0;
                MUXC=1;
                break;
        case 5: MUXA=1;
                MUXB=0;
                MUXC=1;
                break;
        case 6: MUXA=0;
                MUXB=1;
                MUXC=1;
                break;
        case 7: MUXA=1;
                MUXB=1;
                MUXC=1;
                break;
        default:MUXA=0;
                MUXB=0;
                MUXC=0;
                break;
    }
}

void taxel::stepUp(){
    selectMotor(x,y);
    switch (lastStep){
        case 1:
            step2();
            break;
        case 2:
            step3();
            break;
        case 3:
            step4();
            break;
        case 4:
            step1();
            break;
    }
    steps++;
    //deactivate.attach(callback(this, &taxel::stop), 0.015);
    wait(0.02);
    stop();
}

void taxel::stepDown(){
    selectMotor(x,y);
    switch (lastStep){
        case 1:
            step4();
            break;
        case 2:
            step1();
            break;
        case 3:
            step2();
            break;
        case 4:
            step3();
            break;
    }
    steps--;
    //deactivate.attach(callback(this, &taxel::stop), 0.015);
    wait(0.02);
    stop();
}

void taxel::setTarget(int target){
    if(target != steps){
        changed = true;
    }
    targetSteps = target;
    
}

bool taxel::stepToTarget(){
    if(!changed){
        return changed;
    }
    if(steps > targetSteps){
        stepDown();
        if(steps == targetSteps){
            changed = false;
        }
        return changed;
    }
    
    if(steps < targetSteps){
        stepUp();
        if(steps == targetSteps){
            changed = false;
        }
        return changed;
    }
    return changed;  //Should never get here
}











