#include "mbed.h"
#include "tactile_display.hpp"
#include "tactile_mouse.hpp"

tactileDisplay::tactileDisplay(){}

tactileDisplay::tactileDisplay(int x, int y){
    xSize = x;
    ySize = y;
    size = x * y;
    maxActive = size;       //By default, all motors can be active at once;
    
    for(int j=0 ; j<ySize ; ++j){
        for(int i=0 ; i<xSize ; ++i){
            taxel* tempTaxel = new taxel(i,j);
            taxels.push_back(tempTaxel);
        }
    }
}

tactileDisplay::tactileDisplay(int x, int y, int max){
    xSize = x;
    ySize = y;
    size = x * y;
    maxActive = max;
    
    for(int j=0 ; j<ySize ; ++j){
        for(int i=0 ; i<xSize ; ++i){
            taxel* tempTaxel = new taxel(i,j);
            taxels.push_back(tempTaxel);
        }
    }
}

tactileDisplay::~tactileDisplay(){
    xSize = 8;
    ySize = 8;
    size = 64;
    
    for(int i=0 ; i<xSize ; ++i){
        for(int j=0 ; j<ySize ; ++j){
            taxel* tempTaxel = new taxel(i,j);
            taxels.push_back(tempTaxel);
        }
    }
    
}

void zero(){}

int tactileDisplay::coordtoidx(int x, int y){
    int idx=-1;
    
    if((x>=0)&&(x<xSize)){
        if((y>=0)&&(y<ySize)){
            idx = (xSize*y) + x;
        }
    }
    return idx;
}

void tactileDisplay::setTaxel(int x, int y, int target){
    int idx = coordtoidx(x,y);
    taxels[idx]->setTarget(target);
}

void tactileDisplay::stepDisplay(){
    int nMoved = 0;
    vector<int> moved;
    for(int i=0 ; ((i<size) && (nMoved<=maxActive)) ; ++i){
        if(taxels[i]->stepToTarget()){
            nMoved++;
            moved.push_back(i);
        }
    }
    //for(int i=0 ; i<nMoved ; ++i){
    //    taxels[moved[i]]->stop();
    //}
}