#include "mbed.h"
#include "tactile_mouse.hpp"
#include "stepper.hpp"

void M1downstep1(double delay){
    MotorA1=0;
    MotorA2=1;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1downstep2(double delay){
    MotorA1=0;
    MotorA2=1;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1downstep3(double delay){
    MotorA1=1;
    MotorA2=0;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1downstep4(double delay){
    MotorA1=1;
    MotorA2=0;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1upstep1(double delay){
    MotorA1=1;
    MotorA2=0;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1upstep3(double delay){
    MotorA1=1;
    MotorA2=0;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1upstep5(double delay){
    MotorA1=0;
    MotorA2=1;
    MotorB1=1;
    MotorB2=0;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }

void M1upstep7(double delay){
    MotorA1=0;
    MotorA2=1;
    MotorB1=0;
    MotorB2=1;
    wait(0.000001);
    step = 1;
    wait(0.000001);
    step=0;
    wait(delay);
    }
    
    
void M1stop(double delay){
    MotorA1=0;
    MotorA2=0;
    MotorB1=0;
    MotorB2=0;
    wait(0.00001);
    step = 1;
    wait(0.00001);
    step=0;
    }
    
//Extend and retract functions take time delay in S
void M1down(double delay){
    M1upstep7(delay);
    M1upstep5(delay);
    M1upstep3(delay);
    M1upstep1(delay);
    M1stop(0);
}//Steps are different - sequence actually turns out to be the same as the up sequence!
    
void M1up(double delay){
    M1upstep1(delay);
    M1upstep3(delay);
    M1upstep5(delay);
    M1upstep7(delay);
    M1stop(0);
}

    
    
void selectMotor(int x, int y){
    switch (x){
        case 0: BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
        case 1: BOARD_MUXA=1;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
        case 2: BOARD_MUXA=0;
                BOARD_MUXB=1;
                BOARD_MUXC=0;
                break;
        case 3: BOARD_MUXA=1;
                BOARD_MUXB=1;
                BOARD_MUXC=0;
                break;
        case 4: BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=1;
                break;
        case 5: BOARD_MUXA=1;
                BOARD_MUXB=0;
                BOARD_MUXC=1;
                break;
        case 6: BOARD_MUXA=0;
                BOARD_MUXB=1;
                BOARD_MUXC=1;
                break;
        case 7: BOARD_MUXA=1;
                BOARD_MUXB=1;
                BOARD_MUXC=1;
                break;
        default:BOARD_MUXA=0;
                BOARD_MUXB=0;
                BOARD_MUXC=0;
                break;
    }
    switch (y){
        case 0: MUXA=0;
                MUXB=0;
                MUXC=0;
                break;
        case 1: MUXA=1;
                MUXB=0;
                MUXC=0;
                break;
        case 2: MUXA=0;
                MUXB=1;
                MUXC=0;
                break;
        case 3: MUXA=1;
                MUXB=1;
                MUXC=0;
                break;
        case 4: MUXA=0;
                MUXB=0;
                MUXC=1;
                break;
        case 5: MUXA=1;
                MUXB=0;
                MUXC=1;
                break;
        case 6: MUXA=0;
                MUXB=1;
                MUXC=1;
                break;
        case 7: MUXA=1;
                MUXB=1;
                MUXC=1;
                break;
        default:MUXA=0;
                MUXB=0;
                MUXC=0;
                break;
    }
}