#include "mbed.h"
#include "tactile_mouse.hpp"
#include "braille_mouse.hpp"
#include "tactile_display.hpp"
#include "stepper.hpp"
#include <vector>
#include <ctime>

//  ***PINS FOR EMBEDDED PCB***
DigitalOut MotorA1(PD_4);
DigitalOut MotorA2(PD_3);
DigitalOut MotorB1(PD_1);
DigitalOut MotorB2(PD_2);
DigitalOut MUXA(PD_0);
DigitalOut MUXB(PC_12);
DigitalOut MUXC(PC_11);
DigitalOut BOARD_MUXA(PE_6);
DigitalOut BOARD_MUXB(PE_5);
DigitalOut BOARD_MUXC(PE_4);
DigitalOut step(PD_5);
DigitalOut motorPower(PC_4);  //Power enable pin 44
DigitalIn reversePin(PG_0, PullDown);

Thread displayThread;
bool running;

void refreshDisplay(tactileDisplay *display){
    int count = 0;
    while(running){
        (*display).stepDisplay();
        //if((count%50)==0){
            //removePin = !removePin;
        //}
        count++;
    }
    //Clear all latches
    for(int m=0 ; m<8 ; m++){
        for(int n=0 ; n<8 ; n++){
            selectMotor(m,n);
            M1stop(0.0005);
        }
    }
}


int main() {
    
    tactileDisplay display(8,8,3);
    
    step = 0;
    motorPower = 0;
    running = false;
    
    //Clear all latches
    for(int m=0 ; m<8 ; m++){
        for(int n=0 ; n<8 ; n++){
            selectMotor(m,n);
            M1stop(0.0005);
        }
    }
    
    motorPower = 1;
    
    //Establish serial connection
    Serial pc(USBTX, USBRX);
    
    running = true;
    displayThread.start(callback(refreshDisplay, &display));
    char xin,yin;
    char zin[5];
    int x,y,z;
    
    while(1){
        if(pc.readable()){
            xin = pc.getc();
            pc.getc();      //Throw away separator
            yin = pc.getc();
            pc.getc();      //Throw away separator
            pc.scanf("%s",zin);
            
            //Make x integer
            x = xin - '0';
            
            //Make y integer
            y = yin - '0';
            
            //Make z integer
            if(zin[0] == '-'){        //if negative
                z = ((zin[1])+(zin[2]*10)+(zin[3]*100)+(zin[4]*1000))*(-1);
            }
            else{                   //if positive
                z = ((zin[0])+(zin[1]*10)+(zin[2]*100)+(zin[3]*1000)+(zin[4]*10000))
            }
            
            display.setTaxel(x,y,z);
        }
    }
    
    brailleCharacter(display, 0, 'e');
    brailleCharacter(display, 1, 'i');
    brailleCharacter(display, 2, 'e');
    
    wait(15);
    
    brailleCharacter(display, 3, 'n');
    brailleCharacter(display, 4, 'i');
    brailleCharacter(display, 5, 'w');
    
    wait(15);
    
    brailleCharacter(display, 0, 'g');
    brailleCharacter(display, 1, 'i');
    brailleCharacter(display, 2, 'b');
    
    wait(15);
    
    brailleCharacter(display, 0, 'g');
    brailleCharacter(display, 1, 'o');
    brailleCharacter(display, 2, 'd');
    
    wait(15);
    
    /*
    //SQUARE
    display.setTaxel(6,3,50);
    display.setTaxel(3,3,50);
    display.setTaxel(3,4,50);
    display.setTaxel(3,5,50);
    display.setTaxel(6,2,50);
    display.setTaxel(6,3,50);
    display.setTaxel(6,4,50);
    display.setTaxel(6,5,50);
    display.setTaxel(5,2,50);
    display.setTaxel(5,5,50);
    display.setTaxel(4,2,50);
    display.setTaxel(4,5,50);
    */
    /*int dist = -4000;
    if(reversePin == 1){ dist = dist * (-1);}
    
    for(int i=0 ; i<7 ; ++i){
        for(int j=0 ; j<8 ; ++j){
            display.setTaxel(i,j,(rand()%50));
        }
    }
    */
    wait(30);
    
    for(int i=0 ; i<7 ; ++i){
        for(int j=0 ; j<8 ; ++j){
            display.setTaxel(i,j,0);
        }
    }
    
    wait(50);
    
    running = false;
    wait(1);
    displayThread.join();
    
    //Clear all latches
    for(int m=0 ; m<8 ; m++){
        for(int n=0 ; n<8 ; n++){
            selectMotor(m,n);
            M1stop(0.0005);
        }
    }    
}


