#include "braille_mouse.hpp"
#include "tactile_mouse.hpp"

/*  CELL OFFSETS
76543210
22-11-00 0
22-11-00 1
22-11-00 2
-------- 3
-------- 4
55-44-33 5
55-44-33 6
55-44-33 7
*/

void brailleCharacter(tactileDisplay &display, int cell, char character){
    int xOffset = getXOffset(cell);
    int yOffset = getYOffset(cell);
    
    if ((character == 'c')||
        (character == 'd')||
        (character == 'f')||
        (character == 'g')||
        (character == 'i')||
        (character == 'j')||
        (character == 'm')||
        (character == 'n')||
        (character == 'p')||
        (character == 'q')||
        (character == 's')||
        (character == 't')||
        (character == 'w')||
        (character == 'x')||
        (character == 'y')||
        (character == '3')||
        (character == '4')||
        (character == '6')||
        (character == '7')||
        (character == '9')||
        (character == '0'))
        {display.setTaxel((6+xOffset),(0+yOffset),100);}
    else{display.setTaxel((6+xOffset),(0+yOffset),0);}
    if ((character == 'd')||
        (character == 'e')||
        (character == 'g')||
        (character == 'h')||
        (character == 'j')||
        (character == 'n')||
        (character == 'o')||
        (character == 'q')||
        (character == 'r')||
        (character == 't')||
        (character == 'w')||
        (character == 'y')||
        (character == 'z')||
        (character == '4')||
        (character == '5')||
        (character == '7')||
        (character == '8')||
        (character == '0'))
        {display.setTaxel((5+xOffset),(0+yOffset),100);}
    else{display.setTaxel((5+xOffset),(0+yOffset),0);}
    if ((character == 'u')||
        (character == 'v')||
        (character == 'w')||
        (character == 'x')||
        (character == 'y')||
        (character == 'z'))
        {display.setTaxel((4+xOffset),(0+yOffset),100);}
    else{display.setTaxel((4+xOffset),(0+yOffset),0);}
    if ((character == 'i')||
        (character == 'j')||
        (character == 's')||
        (character == 't')||
        (character == 'w')||
        (character == '9')||
        (character == '0'))
        {display.setTaxel((6+xOffset),(1+yOffset),0);}
    else{display.setTaxel((6+xOffset),(1+yOffset),100);}
    if ((character == 'a')||
        (character == 'c')||
        (character == 'd')||
        (character == 'e')||
        (character == 'k')||
        (character == 'm')||
        (character == 'n')||
        (character == 'o')||
        (character == 'u')||
        (character == 'x')||
        (character == 'y')||
        (character == 'z')||
        (character == '1')||
        (character == '3')||
        (character == '4')||
        (character == '5'))
        {display.setTaxel((5+xOffset),(1+yOffset),0);}
    else{display.setTaxel((5+xOffset),(1+yOffset),100);}
    if ((character == 'k')||
        (character == 'l')||
        (character == 'm')||
        (character == 'n')||
        (character == 'o')||
        (character == 'p')||
        (character == 'q')||
        (character == 'r')||
        (character == 's')||
        (character == 't')||
        (character == 'u')||
        (character == 'v')||
        (character == 'x')||
        (character == 'y')||
        (character == 'z'))
        {display.setTaxel((4+xOffset),(1+yOffset),100);}
    else{display.setTaxel((4+xOffset),(1+yOffset),0);}
}

/*  CELL OFFSETS
76543210
-000-333 0
-000-333 1
-------- 2
-111-444 3
-111-444 4
-------- 5
-222-555 6
-222-555 7
*/

int getYOffset(int cell){
    if ((cell == 0)||(cell == 3)){
        return 0;
    }
    else if ((cell == 1)||(cell == 4)){
        return 3;
    }
    else if ((cell == 2)||(cell == 5)){
        return 6;
    }
    return -1;
}

int getXOffset(int cell){
    if ((cell == 0)||(cell == 1)||(cell == 2)){
        return 0;
    }
    else if ((cell == 3)||(cell == 4)||(cell == 5)){
        return 4;
    }
    return -1;
    
}