#include "mbed.h"
#include "Button.hpp"

void br_callback(int dur)
{
    printf("\r\n!! button RELEASE called, press time: %d msec\r\n", dur);
}

void bp_callback(void)
{
    printf("\r\n!! button PRESS called\r\n");
}

int main() {
    int k, dur;
    Button* button_ptr;
    
    printf("Testing button class\r\n");
    printf("Test Standard polling type implementation\r\n");
    button_ptr = new Button(USER_BUTTON, Button::ActiveHigh);
    while( (k=button_ptr->chkButton_press(&dur)) == 0 )
        /* wait */;
    printf(">Button pressed %d times, last was %d msec\r\n",k,dur);
    delete button_ptr;
    
    printf("\nTest with Release callback\r\n");
    button_ptr = new Button(USER_BUTTON, Button::ActiveHigh, br_callback);
    while( (k=button_ptr->chkButton_press(&dur)) == 0 )
        /* wait */;
    printf(">Button pressed %d times, last was %d msec\r\n",k,dur);
    delete button_ptr;
        
    printf("\nTest with Press & Release callback\r\n");
    button_ptr = new Button(USER_BUTTON, Button::ActiveHigh, br_callback);
    button_ptr->setButton_press_cb(bp_callback);
    while( (k=button_ptr->chkButton_press(&dur)) == 0 )
        /* wait */;
    printf(">Button pressed %d times, last was %d msec\r\n",k,dur);
    while (1) {
        wait(.5);
    }

}