#include "mbed.h"
#include "Adafruit_Si4713.h"

/* For the demo use PWM (p25) connected to LIN to play... */
PwmOut muzak(p25);
float frequency[]={659, 554, 659, 554, 440, 494, 554, 587, 494, 659, 554, 440};
float beat[]={1,1,1,1,1,0.5,0.5,1,1,1,1,2};

uint16_t fmstation = 9350;      // 9350 == 93.5 MHz

I2C myi2c(p9,p10);
Adafruit_Si4713 radio = Adafruit_Si4713(myi2c, p5, 0x63<<1);

int main() {
  printf("Adafruit Radio - Si4713 Test\r\n");

  if (! radio.begin()) {
    printf("Couldn't find radio?\r\n");
    while (1);
  }

  // Uncomment to scan power of entire range from 87.5 to 108.0 MHz
  for (uint16_t f  = 8750; f<10800; f+=10) {
    radio.readTuneMeasure(f);
    printf("Measuring %.1f\t",f/100.0);
    radio.readTuneStatus();
    printf("%i\r\n",radio.currNoiseLevel);
  }

  printf("\n\rSet TX power");
  radio.setTXpower(115);  // dBuV, 88-115 max

  printf("\n\rTuning into %.1f\r\n",fmstation/100.0); 
  radio.tuneFM(fmstation);

  // This will tell you the status in case you want to read it from the chip
  radio.readTuneStatus();
  printf("\tCurr freq: %d\r\n", radio.currFreq); 
  printf("\tCurr freqdBuV: %d\r\n", radio.currdBuV); 
  printf("\tCurr ANTcap: %d\r\n", radio.currAntCap); 

  while (1) {
        for (int i = 0; i<=11; i++) {
            muzak.period(1/(2*frequency[i]));
            muzak = 0.5;
            wait(0.4*beat[i]);
        }
  }
}
