#include "TFT_4DGL.h"

TFT_4DGL lcd(p9,p10,p11);

int main() {
   
    double ImageHeight = 220;
    double ImageWidth = 220;
    double MinRe = -1.6;
    double MaxRe = 0.8;
    double MinIm = -1.1;
    double MaxIm = MinIm+(MaxRe-MinRe)*ImageHeight/ImageWidth;
    double Re_factor = (MaxRe-MinRe)/(ImageWidth-1);
    double Im_factor = (MaxIm-MinIm)/(ImageHeight-1);
    unsigned MaxIterations = 15;
    
 
 while (1) {
 
    for(unsigned y=0; y<ImageHeight; ++y)
    {
    double c_im = MaxIm - y*Im_factor;
    for(unsigned x=0; x<ImageWidth; ++x)
    {
        double c_re = MinRe + x*Re_factor;

        double Z_re = c_re, Z_im = c_im;
        bool isInside = true;
        for(unsigned n=0; n<MaxIterations; ++n)
        {
            double Z_re2 = Z_re*Z_re, Z_im2 = Z_im*Z_im;
            if(Z_re2 + Z_im2 > 4)
            {
                isInside = false;
                break;
            }
            Z_im = 2*Z_re*Z_im + c_im;
            Z_re = Z_re2 - Z_im2 + c_re;
        }
        if(isInside) {

        lcd.pixel(y,60+x,WHITE);
        
    }
    }
    }
  
}
}