#include "TFT_4DGL.h"

TFT_4DGL lcd(p9,p10,p11);

int main() {
   
    float xmin = -2.5; 
    float ymin = -2.0;
    float wh = 4;
    
    int maxiterations = 100;
    int width = 320;
    int height = 320;

    float xmax = xmin+wh;

    float ymax = ymin+wh;
  
    float dx = (xmax - xmin) / (width);
    float dy = (ymax - ymin) / (height);

    float y = ymin;
    
 
    for (int j = 0; j < (height); j++) {

    float x = xmin;
    for (int i = 0;  i < width; i++) {
      
      float a = x;
      float b = y;
      int n = 0;
      while (n < maxiterations) {
        
        float aa = a * a;
        float bb = b * b;
        float twoab = 2.0 * a * b;
        a = aa - bb + x;
        b = twoab + y;
        
        if(aa + bb > 16.0) {
          break;
        }
        n++;
      }

      if (n == maxiterations) {
        
      } else {

        lcd.pixel(120+80*y,210+80*x,n*n*n*n*n*n*n*n);
       
      }
      x += dx;
    }
    y += dy;
  }

}