#include "TFT_4DGL.h"

TFT_4DGL lcd(p9,p10,p11);

#define GRID_X 30
#define GRID_Y 30

#define MAX_GENERATIONS 250

uint8_t grid[2][GRID_X][GRID_Y];
uint8_t current_grid = 0;
uint8_t generations = 0;


void initGrid()
{
 int i, j;
 lcd.cls();
 current_grid = 0;
 for (i = 0; i < GRID_X; i++) {
 for (j = 0; j < GRID_Y; j++) {
 if ((uint8_t) rand() % 3 == 0) {
 grid[0][i][j] = 1;
 } else {
 grid[0][i][j] = 0;
 }
 }
 }
}


void drawGrid()
{
 uint8_t  x,  y;
 uint8_t cx, cy;
 cx = 1;
 cy = 1;
 for (y = 0; y < GRID_Y; y++) {
 cx = 1;
 for (x = 0; x < GRID_X; x++) {
 if (grid[1-current_grid][x][y] != grid[current_grid][x][y]) {
 if(grid[current_grid][x][y]) {
    lcd.circle(cx,40+cy,2,WHITE);
 }
    else {
   lcd.circle(cx,40+cy,2,BLACK);
 }
 }
 cx += 8;
 }
 cy += 8;
 }
}


int count_neighbours(int x, int y)
{
 int i, j;
 int result = 0;

 x--;
 y--;
 for (i = 0; i < 3; i++) {
 if (y < 0 || y > (GRID_Y - 1)) { continue; }
 for (j = 0; j < 3; j++) {
 if (x < 0 || x > (GRID_X - 1)) { continue; }
 if (i==1 && j == 1) { x++; continue; }
 if (grid[current_grid][x][y]) { result++; }
 x++;
 }
 y++;
 x -= 3;
 }
 return result;
}


int cmpGrid()
{
 int i, j;
 for (i=0; i < GRID_Y; i++) {
 for (j=0; j < GRID_X; j++) {
 if (grid[0][i][j] != grid[1][i][j]) { return 0; }
 }
 }
 return 1;
}

void runGrid()
{
 uint8_t x, y;
 int count;
 uint8_t value = 0;
 uint8_t new_grid;

 new_grid = 1 - current_grid;
 for (y = 0; y < GRID_Y; y++) {
 for (x = 0; x < GRID_X; x++) {
 count = count_neighbours(x, y);
 if (count < 2 || count > 3) { value = 0; }
 else if (count == 3) { value = 3; }
 else { value = grid[current_grid][x][y]; }
 grid[new_grid][x][y] = value;
 }
 }
 current_grid = new_grid;
}

int main()
{
  
        initGrid();
        drawGrid();


while(1)
{
 runGrid();
 drawGrid();
 generations++;
 if (generations > MAX_GENERATIONS || cmpGrid()) {
 generations = 0;
 initGrid();
 }
}
}