#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(p5, p7,p8);  // MOSI, SCLK, CS

int main() {

    MCP.frequency(1000000);

    float x = 0.5;
    float y = 0.25;
    float z = 0.125;
    float oldx = 0;
    float oldy = 0;
    float oldz = 0;
        
    float dt = 0.005;
    
    float alpha = 15.6;
    float beta = 28.58;
    float a = -1.14286;
    float b = -0.714286;
    float h = 0;
    
    int xout = 0;
    int yout = 0;

    while (1) {

    oldx = x;
    oldy = y;
    oldz = z;

    h = (b * x) + (0.5 * (a - b) * (abs(x+1) - abs(x-1)));
                
    x = oldx + dt * (alpha * (oldy - oldx - h));
    y = oldy + dt * (oldx - oldy + oldz);
    z = oldz + dt * (-beta * oldy);
    
    xout = 2047+(850*x);        
    yout = 2047+6*(800*y);
   
    MCP.writeA(xout);
    MCP.writeB(yout);

    }
}