#include "mbed.h"

Serial _cmd (p9, p10);
DigitalOut _rst (p11);

void startVGA();
void baudrate();    
void cls();
void pixel(int, int, int);
int  writeCOM(char *, int);


int main() {

    startVGA ();
  
    float x = 1;
    float y = 1;
  
    float ix = 0;
    float iy = 0;
  
    float a = -1.4;
    float b = 1.6;
    float c = 1;
    float d = 0.7;
 
 while (1) {
 
    ix = sin(a*y) - c*cos(a*x);
    iy = sin(b*x) - d*cos(b*y);
    
    pixel(375+(180*ix),255+(150*iy),65534);
   
    x = ix;
    y = iy;  
  
}
}


void startVGA () {

    _rst = 1;
    _rst = 0;
    wait_ms(1);
    _rst = 1;
    wait(3);

    while (_cmd.readable()) _cmd.getc();
    
    char autobaud[1] = "";
    autobaud[0] = '\x55';
    writeCOM(autobaud, 1);
    
    baudrate();
   
    cls();
    
    char dispctr[3]= "";
    dispctr[0] = '\x59';
    dispctr[1] = 0x0c;
    dispctr[2] = 0x01;
    writeCOM(dispctr, 3);

}


void pixel(int x, int y, int color) {

    char pixel[7]= "";

    pixel[0] = '\x50';

    pixel[1] = (x >> 8) & 0xFF;
    pixel[2] = x & 0xFF;

    pixel[3] = (y >> 8) & 0xFF;
    pixel[4] = y & 0xFF;

    pixel[5] = (color >> 8) & 0xFF;
    pixel[6] = color & 0xFF;

    writeCOM(pixel, 7);
}


void baudrate() {

    char baudrate[2]= "";
    
    baudrate[0] = '\x51';
    baudrate[1] = '\x0F';

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();
    
    long speed = speed = 281000;
        
    for (i = 0; i <2; i++)  _cmd.putc(baudrate[i]);
    _cmd.baud(speed);                                 

    while (!_cmd.readable()) wait_ms(1);        

    if (_cmd.readable()) resp = _cmd.getc();        
    switch (resp) {
        case '\x06' :                                 
            resp =  1;
            break;
        case '\x15' :                                  
            resp = -1;
            break;
        default :
            resp =  0;
            break;
    }

}


int writeCOM(char *command, int number) {

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();

    for (i = 0; i < number; i++)  _cmd.putc(command[i]);

    while (!_cmd.readable()) wait_ms(1);   
    if (_cmd.readable()) resp = _cmd.getc();
    switch (resp) {
        case '\x06' :
            resp =  1;
            break;
        case '\x15' :                        
            resp = -1;  
            break;
        default :
            resp =  0;                             
            break;
    }

    return resp;
}


void cls() {
    char cls[1] = "";
    cls[0] = '\x45';
    writeCOM(cls, 1);
}
