#include "mbed.h"

Serial _cmd (p9, p10);
DigitalOut _rst (p11);

void startVGA();
void baudrate();    
void cls();
void pixel(int, int, int);
int  writeCOM(char *, int);


int main() {

    startVGA ();
   
    float x = 0.5;
    float y = 0.25;
    float z = 0.125;
    float oldx = 0;
    float oldy = 0;
    float oldz = 0;
        
    float dt = 0.02;
    
    float alpha = 15.6;
    float beta = 28.58;
    float a = -1.14286;
    float b = -0.714286;
    float h = 0;
    
    int xout = 0;
    int yout = 0;
    int col = 0;
    int cnt = 0;
 
 while (1) {
 
    oldx = x;
    oldy = y;
    oldz = z;

    h = (b * x) + (0.5 * (a - b) * (abs(x+1) - abs(x-1)));
                
    x = oldx + dt * (alpha * (oldy - oldx - h));
    y = oldy + dt * (oldx - oldy + oldz);
    z = oldz + dt * (-beta * oldy);
    
    xout = 320+(130*x);
    yout = 240+(430*y);        
   
    pixel(xout,yout,col);
    
    cnt ++;
    
    if (cnt == 100) {
    
     col = rand();
     
     cnt = 0;
     
     }
  
}
}


void startVGA () {

    _rst = 1;
    _rst = 0;
    wait_ms(1);
    _rst = 1;
    wait(3);

    while (_cmd.readable()) _cmd.getc();
    
    char autobaud[1] = "";
    autobaud[0] = '\x55';
    writeCOM(autobaud, 1);
    
    baudrate();
   
    cls();
    
    char dispctr[3]= "";
    dispctr[0] = '\x59';
    dispctr[1] = 0x0c;
    dispctr[2] = 0x01;
    writeCOM(dispctr, 3);

}


void pixel(int x, int y, int color) {

    char pixel[7]= "";

    pixel[0] = '\x50';

    pixel[1] = (x >> 8) & 0xFF;
    pixel[2] = x & 0xFF;

    pixel[3] = (y >> 8) & 0xFF;
    pixel[4] = y & 0xFF;

    pixel[5] = (color >> 8) & 0xFF;
    pixel[6] = color & 0xFF;

    writeCOM(pixel, 7);
}


void baudrate() {

    char baudrate[2]= "";
    
    baudrate[0] = '\x51';
    baudrate[1] = '\x0F';

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();
    
    long speed = speed = 281000;
        
    for (i = 0; i <2; i++)  _cmd.putc(baudrate[i]);
    _cmd.baud(speed);                                 

    while (!_cmd.readable()) wait_ms(1);        

    if (_cmd.readable()) resp = _cmd.getc();        
    switch (resp) {
        case '\x06' :                                 
            resp =  1;
            break;
        case '\x15' :                                  
            resp = -1;
            break;
        default :
            resp =  0;
            break;
    }

}


int writeCOM(char *command, int number) {

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();

    for (i = 0; i < number; i++)  _cmd.putc(command[i]);

    while (!_cmd.readable()) wait_ms(1);   
    if (_cmd.readable()) resp = _cmd.getc();
    switch (resp) {
        case '\x06' :
            resp =  1;
            break;
        case '\x15' :                        
            resp = -1;  
            break;
        default :
            resp =  0;                             
            break;
    }

    return resp;
}


void cls() {
    char cls[1] = "";
    cls[0] = '\x45';
    writeCOM(cls, 1);
}
