#include "mbed.h"
#include "vga640x480g.h"

int main() {

    init_vga();

    vga_cls();

    vga_box(0,0,639,479,WHITE);
    
    vga_putstring(10,10,"Chua chaotic oscillator",WHITE);
    
    float x = 0.5;
    float y = 0.25;
    float z = 0.125;
    float oldx = 0;
    float oldy = 0;
    float oldz = 0;
        
    float dt = 0.005;
    
    float alpha = 15.6;
    float beta = 28.58;
    float a = -1.14286;
    float b = -0.714286;
    float h = 0;
    
    int xout = 0;
    int yout = 0;
 
 while (1) {
 
    oldx = x;
    oldy = y;
    oldz = z;

    h = (b * x) + (0.5 * (a - b) * (abs(x+1) - abs(x-1)));
                
    x = oldx + dt * (alpha * (oldy - oldx - h));
    y = oldy + dt * (oldx - oldy + oldz);
    z = oldz + dt * (-beta * oldy);
    
    xout = 320+(136*x);
    yout = 240+(556*y); 

    vga_plot(xout,yout,WHITE);
    
}

  }    
   