#include "mbed.h"

Serial _cmd (p9, p10);
DigitalOut _rst (p11);

void startVGA();
void baudrate();    
void cls();
void pixel(int, int, int);
int  writeCOM(char *, int);
void DisplayState(int*,int, int);


int main() {

    startVGA ();

  int iteration = 480;
  int lenght = 640;

  int rules[8] = {1,1,1,0,1,0,0,1};

  int row = 0;
  
  int i,j,k;
  int state[lenght];
  int newstate[lenght];
  
    while(1) {
     
     for (i=0;i<lenght;i++)
  
      state[i]= int (rand()%2);

   for (i=0;i<iteration;i++) {

      for (j=0;j<lenght;j++)
         newstate[j] = 0;

      for (j=0;j<lenght;j++) {
         k = 4*state[(j-1+lenght)%lenght] + 2*state[j] + state[(j+1)%lenght];
         newstate[j] = rules[k];
      }

      for (j=0;j<lenght;j++)
         state[j] = newstate[j];

      DisplayState(state,lenght,row);
      
      row = row + 1;
      
      if (row == 480) {
      
      row = 0;
      
      }

   }

    }
}


void DisplayState(int s[],int len, int row)
{
   int i;

   for (i=0;i<len;i++) {
      if (s[i] == 1){
        
        pixel (i,row,65534);
        
       }
         
      else{
       
       pixel (i,row,0);
       
        }
        
      }
      
}

void startVGA () {

    _rst = 1;
    _rst = 0;
    wait_ms(1);
    _rst = 1;
    wait(3);

    while (_cmd.readable()) _cmd.getc();
    
    char autobaud[1] = "";
    autobaud[0] = '\x55';
    writeCOM(autobaud, 1);
    
    baudrate();
   
    cls();
    
    char dispctr[3]= "";
    dispctr[0] = '\x59';
    dispctr[1] = 0x0c;
    dispctr[2] = 0x01;
    writeCOM(dispctr, 3);

}


void pixel(int x, int y, int color) {

    char pixel[7]= "";

    pixel[0] = '\x50';

    pixel[1] = (x >> 8) & 0xFF;
    pixel[2] = x & 0xFF;

    pixel[3] = (y >> 8) & 0xFF;
    pixel[4] = y & 0xFF;

    pixel[5] = (color >> 8) & 0xFF;
    pixel[6] = color & 0xFF;

    writeCOM(pixel, 7);
}


void baudrate() {

    char baudrate[2]= "";
    
    baudrate[0] = '\x51';
    baudrate[1] = '\x0F';

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();
    
    long speed = speed = 281000;
        
    for (i = 0; i <2; i++)  _cmd.putc(baudrate[i]);
    _cmd.baud(speed);                                 

    while (!_cmd.readable()) wait_ms(1);        

    if (_cmd.readable()) resp = _cmd.getc();        
    switch (resp) {
        case '\x06' :                                 
            resp =  1;
            break;
        case '\x15' :                                  
            resp = -1;
            break;
        default :
            resp =  0;
            break;
    }

}


int writeCOM(char *command, int number) {

    int i, resp = 0;
    
    while (_cmd.readable()) _cmd.getc();

    for (i = 0; i < number; i++)  _cmd.putc(command[i]);

    while (!_cmd.readable()) wait_ms(1);   
    if (_cmd.readable()) resp = _cmd.getc();
    switch (resp) {
        case '\x06' :
            resp =  1;
            break;
        case '\x15' :                        
            resp = -1;  
            break;
        default :
            resp =  0;                             
            break;
    }

    return resp;
}


void cls() {
    char cls[1] = "";
    cls[0] = '\x45';
    writeCOM(cls, 1);
}