#ifndef MAX30102_H_
#define MAX30102_H_

#include "mbed.h"

class MAX30102 
{
public:
    MAX30102(PinName sda, PinName scl) : _i2c(sda, scl) {

    }
    bool init();
    bool read_fifo(uint32_t *pun_red_led, uint32_t *pun_ir_led);
    bool reset();

private:
    static const uint8_t I2C_ADDR = 0xAE;

    static const uint8_t  REG_INTR_STATUS_1 = 0x00;
    static const uint8_t  REG_INTR_STATUS_2 = 0x01;
    static const uint8_t  REG_INTR_ENABLE_1 = 0x02;
    static const uint8_t  REG_INTR_ENABLE_2 = 0x03;
    static const uint8_t  REG_FIFO_WR_PTR = 0x04;
    static const uint8_t  REG_OVF_COUNTER = 0x05;
    static const uint8_t  REG_FIFO_RD_PTR = 0x06;
    static const uint8_t  REG_FIFO_DATA = 0x07;
    static const uint8_t  REG_FIFO_CONFIG = 0x08;
    static const uint8_t  REG_MODE_CONFIG = 0x09;
    static const uint8_t  REG_SPO2_CONFIG = 0x0A;
    static const uint8_t  REG_LED1_PA = 0x0C;
    static const uint8_t  REG_LED2_PA = 0x0D;
    static const uint8_t  REG_PILOT_PA = 0x10;
    static const uint8_t  REG_MULTI_LED_CTRL1 = 0x11;
    static const uint8_t  REG_MULTI_LED_CTRL2 = 0x12;
    static const uint8_t  REG_TEMP_INTR = 0x1F;
    static const uint8_t  REG_TEMP_FRAC = 0x20;
    static const uint8_t  REG_TEMP_CONFIG = 0x21;
    static const uint8_t  REG_PROX_INT_THRESH = 0x30;
    static const uint8_t  REG_REV_ID = 0xFE;
    static const uint8_t  REG_PART_ID = 0xFF;

    I2C _i2c;

    bool write_reg(uint8_t uch_addr, uint8_t uch_data);
    bool read_reg(uint8_t uch_addr, uint8_t *puch_data);

};

#endif /* MAX30102_H_ */