#include "mbed.h"
#include "MAX30102.h"

bool MAX30102::write_reg(uint8_t uch_addr, uint8_t uch_data)
{
  char ach_i2c_data[2];
  ach_i2c_data[0]=uch_addr;
  ach_i2c_data[1]=uch_data;
  
  if(_i2c.write(I2C_ADDR, ach_i2c_data, 2, false)==0) return true;
  else  return false;
}

bool MAX30102::read_reg(uint8_t uch_addr, uint8_t *puch_data)
{
  char ch_i2c_data;
  ch_i2c_data=uch_addr;

  if(_i2c.write(I2C_ADDR, &ch_i2c_data, 1, true)!=0)  return false;

  if(_i2c.read(I2C_ADDR | 0x01, &ch_i2c_data, 1, false)==0)
  {
    *puch_data=(uint8_t) ch_i2c_data;
    return true;
  }
  else
    return false;
}

bool MAX30102::init()
{
  if(!write_reg(REG_INTR_ENABLE_1,0xc0))  return false;
  if(!write_reg(REG_INTR_ENABLE_2,0x00))  return false;
  if(!write_reg(REG_FIFO_WR_PTR,0x00))    return false;
  if(!write_reg(REG_OVF_COUNTER,0x00))    return false;
  if(!write_reg(REG_FIFO_RD_PTR,0x00))    return false;
  if(!write_reg(REG_FIFO_CONFIG,0x0f))    return false;
  if(!write_reg(REG_MODE_CONFIG,0x03))    return false;
  if(!write_reg(REG_SPO2_CONFIG,0x27))    return false;
  if(!write_reg(REG_LED1_PA,0x24))        return false;
  if(!write_reg(REG_LED2_PA,0x24))        return false;
  if(!write_reg(REG_PILOT_PA,0x7f))       return false;
  return true;  
}

bool MAX30102::read_fifo(uint32_t *pun_red_led, uint32_t *pun_ir_led)
{
  uint32_t un_temp;
  unsigned char uch_temp;
  *pun_red_led=0;
  *pun_ir_led=0;
  char ach_i2c_data[6];
  
  read_reg(REG_INTR_STATUS_1, &uch_temp);
  read_reg(REG_INTR_STATUS_2, &uch_temp);
  
  ach_i2c_data[0]=REG_FIFO_DATA;
  if(_i2c.write(I2C_ADDR, ach_i2c_data, 1, true)!=0) return false;
  if(_i2c.read(I2C_ADDR | 0x01, ach_i2c_data, 6, false)!=0)  return false;

  un_temp=(unsigned char) ach_i2c_data[0];
  un_temp<<=16;
  *pun_red_led+=un_temp;
  un_temp=(unsigned char) ach_i2c_data[1];
  un_temp<<=8;
  *pun_red_led+=un_temp;
  un_temp=(unsigned char) ach_i2c_data[2];
  *pun_red_led+=un_temp;
  
  un_temp=(unsigned char) ach_i2c_data[3];
  un_temp<<=16;
  *pun_ir_led+=un_temp;
  un_temp=(unsigned char) ach_i2c_data[4];
  un_temp<<=8;
  *pun_ir_led+=un_temp;
  un_temp=(unsigned char) ach_i2c_data[5];
  *pun_ir_led+=un_temp;
  *pun_red_led&=0x03FFFF;  //Mask MSB [23:18]
  *pun_ir_led&=0x03FFFF;  //Mask MSB [23:18]
  
  
  return true;
}

bool MAX30102::reset()
{
    if(!write_reg(REG_MODE_CONFIG,0x40))  return false;
    else  return true;    
}
