#include "mbed.h"
#include <sstream>
#include "easy-connect.h"
#include "https_request.h"
#include "ssl_ca_pem.h"
#include "C12832.h"
#include "MMA7660.h"
#include "LM75B.h"

C12832 lcd(D11, D13, D12, D7, D10);
MMA7660 MMA(D14,D15);
LM75B sensor(D14,D15);

Serial pc(USBTX,USBRX);

const char API_TOKEN[] = "api-token";
const char URL[] = "https://{domain}.cybozu.com/k/v1/record.json";

int app_id = 2;

bool post_kintone(NetworkInterface* nif, const char *url, int app_id_, char* field_code, float value)
{    
    HttpsRequest* post_req = new HttpsRequest(nif, SSL_CA_PEM, HTTP_POST, url);
    post_req->set_header("X-Cybozu-API-Token", API_TOKEN);
    post_req->set_header("Content-Type", "application/json");
    
    std::stringstream ss_body;
        
    ss_body << "{\"app\": " << app_id_ << ", \"record\": {\"" << field_code << "\": {\"value\": \"" << value << "\"}}}\n";
    
    string body = ss_body.str();

    printf("body:%s\r\n",body.c_str());
    
    HttpResponse* post_res = post_req->send(body.c_str(), body.length());
    
    printf("res:%s\r\n",post_res->get_body_as_string().c_str());
    
    
    if(post_res->get_status_code() == 200){
        delete post_req;
        return true;
    }
    
    delete post_req;    
    
    return false;
}

// main() runs in its own thread in the OS
int main() {
    NetworkInterface* network = NULL;

    pc.baud(115200);

    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Network Connect..");

    pc.printf("\r\n----- Start -----\r\n");
    
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        pc.printf("\r\n----- Network Error -----\r\n");
        return -1;
    }

    lcd.printf("OK");
    pc.printf("\r\n----- Network Connected -----\r\n");
    
    wait(2.0);
    
    while(1) {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("x=%.2f y=%.2f z=%.2f",MMA.x(), MMA.y(), MMA.z());
        
        float temp = sensor.read();
        lcd.locate(0,14);
        lcd.printf("Temp = %.1f\n", temp);
        
        bool ret = post_kintone(network, URL, app_id, "temp", temp);
        pc.printf("\n----- HTTPS POST response [%s]----- \n\r",ret== true ? "OK" : "NG");
        
        wait(10.0);
    }
}

