#include "mbed.h"
#include "easy-connect.h"
#include "https_request.h"
#include "Ambient.h"

unsigned int channelId = 0;
const char* writeKey = "";
Ambient ambient;

AnalogIn ain(A0);
Serial pc(USBTX,USBRX);


// main() runs in its own thread in the OS
int main() {
    NetworkInterface* network = NULL;

    pc.baud(9600);

    pc.printf("Network Connect..");

    pc.printf("\r\n----- Start -----\r\n");
    
    network = easy_connect(true);    // If true, prints out connection details.
    if (!network) {
        pc.printf("\r\n----- Network Error -----\r\n");
        return -1;
    }

    pc.printf("\r\n----- Network Connected -----\r\n");
    
    wait(2.0);

    ambient.init(network,channelId, writeKey);
    
    while(1) {
        float tmp = (ain * 3.3 -0.6)/0.01;
        ambient.set(1, tmp);

        bool ret = ambient.send();        
        pc.printf("\n----- HTTPS POST response [%s]----- \n\r",ret== true ? "OK" : "NG");
        
        wait(10.0);
    }
}

