#ifndef Ambient_h
#define Ambient_h

#include "mbed.h"
#include "http_request.h"

#define AMBIENT_WRITEKEY_SIZE 18
#define AMBIENT_MAX_RETRY 5
#define AMBIENT_DATA_SIZE 24
#define AMBIENT_NUM_PARAMS 11
#define AMBIENT_TIMEOUT 3000 // milliseconds

class Ambient
{
public:
    /** Create Ambient instance
     */
    Ambient(void);

    bool init(NetworkInterface* nif, unsigned int channelId, const char * writeKey, int dev = 0);

    /** Set data on field-th field of payload.
     * @param field index of payload (1 to 8)
     * @param data data
     * @returns
     *    true on success,
     *    false on failure
     */
    bool set(int field, char * data);

    /** Set data on field-th field of payload.
     * @param field index of payload (1 to 8)
     * @param data data
     * @returns
     *    true on success,
     *    false on failure
     */
    bool set(int field, int data);

    /** Set data on field-th field of payload.
     * @param field index of payload (1 to 8)
     * @param data data
     * @returns
     *    true on success,
     *    false on failure
     */
    bool set(int field, double data);

    /** Clear data on field-th field of payload.
     * @param field index of payload (1 to 8)
     * @returns
     *    true on success,
     *    false on failure
     */
    bool clear(int field);

    /** Send data to Ambient
     * @returns
     *    true on success,
     *    false on failure
     */
    bool send(void);

private:

    NetworkInterface * _nif;
    unsigned int channelId;
    char writeKey[AMBIENT_WRITEKEY_SIZE];
    int dev;
    char host[18];
    int port;

    struct {
        int set;
        char item[AMBIENT_DATA_SIZE];
    } data[AMBIENT_NUM_PARAMS];
};

#endif // Ambient_h
