#include "Ambient.h"


const char* AMBIENT_HOST = "http://ambidata.io";
const int AMBIENT_PORT = 80;
const char* AMBIENT_HOST_DEV = "192.168.0.6";
const int AMBIENT_PORT_DEV = 4567;

const char * ambient_keys[] = {"\"d1\":\"", "\"d2\":\"", "\"d3\":\"", "\"d4\":\"", "\"d5\":\"", "\"d6\":\"", "\"d7\":\"", "\"d8\":\"", "\"lat\":\"", "\"lng\":\"", "\"created\":\""};

Ambient::Ambient() {
}

bool
Ambient::init(NetworkInterface* nif, unsigned int channelId, const char * writeKey, int dev) {
    this->channelId = channelId;

    if (sizeof(writeKey) > AMBIENT_WRITEKEY_SIZE) {
        return false;
    }
    strcpy(this->writeKey, writeKey);

    if(NULL == nif) {
        return false;
    }
    this->_nif = nif;
    this->dev = dev;
    if (dev) {
        strcpy(this->host, AMBIENT_HOST_DEV);
        this->port = AMBIENT_PORT_DEV;
    } else {
        strcpy(this->host, AMBIENT_HOST);
        this->port = AMBIENT_PORT;
    }
    for (int i = 0; i < AMBIENT_NUM_PARAMS; i++) {
        this->data[i].set = false;
    }
    return true;
}

bool
Ambient::set(int field, char * data) {
    --field;
    if (field < 0 || field >= AMBIENT_NUM_PARAMS) {
        return false;
    }
    if (strlen(data) > AMBIENT_DATA_SIZE) {
        return false;
    }
    this->data[field].set = true;
    strcpy(this->data[field].item, data);

    return true;
}

bool
Ambient::set(int field, int data) {
    char buf[12];
    snprintf(buf, sizeof(buf), "%d", data);
    return (set(field, buf));
}

bool
Ambient::set(int field, double data) {
    char buf[12];
    snprintf(buf, sizeof(buf), "%f", data);
    return (set(field, buf));
}

bool
Ambient::clear(int field) {
    --field;
    if (field < 0 || field >= AMBIENT_NUM_PARAMS) {
        return false;
    }
    this->data[field].set = false;

    return true;
}

bool
Ambient::send() {

    char url[256];

    memset(url, 0, sizeof(url));
    strcat(url, this->host);
    sprintf(&url[strlen(url)], "/api/v2/channels/%d/data", this->channelId);

    HttpRequest* post_req = new HttpRequest(_nif, HTTP_POST, url);

    char body[192];
    char str[180];

    memset(body, 0, sizeof(body));
    strcat(body, "{\"writeKey\":\"");
    strcat(body, this->writeKey);
    strcat(body, "\",");

    for (int i = 0; i < AMBIENT_NUM_PARAMS; i++) {
        if (this->data[i].set) {
            strcat(body, ambient_keys[i]);
            strcat(body, this->data[i].item);
            strcat(body, "\",");
        }
    }
    body[strlen(body) - 1] = '\0';
    strcat(body, "}\r\n");
    
    memset(str, 0, sizeof(str));
    sprintf(str, "%d", strlen(body));
    post_req->set_header("Content-Length", str);
    post_req->set_header("Content-Type", "application/json");

    HttpResponse* post_res = post_req->send(body, strlen(body));
    
    if(post_res->get_status_code() == 200){
        delete post_req;
        return true;
    }
    
    delete post_req;    
    
    return false;
}
