#ifndef MAIN_H
#define MAIN_H

// System
#define ENABLE_COGGING_COMPENSATION     1
#define ENABLE_POSITION_COMPENSATION    1
#define ENABLE_FRICTION_COMPENSATION    1
// Torque Controller
#define TORQUE_CONTROLLER_INTERVAL_US   100
#define TORQUE_CONTROLLER_INTERVAL_INV  10000
#define TORQUE_LIMIT                    2.0f
#define POSITION_RESOLUTION             8192
#define POSITION_ANTIALIAS              4096
#define ELECTRICAL_POSITION_TO_RAD      0.038349f   // 2*pi/(8192/50)
// Friction Model
#define COULOMB_VELOCITY_CONST          9.0f
#define STRIBECK_VELOCITY_CONST         0.5f
#define COULOMB_FRICTION                0.058f
#define STRIBECK_FRICTION               0.060f
#define VISCOUS_FRICTION_COEF_FWD       (float)2.65e-3 //2.16561e-3
#define VISCOUS_FRICTION_COEF_REV       (float)2.55e-3 //2.16561e-3
#define ENABLE_DITHER                   0
#define DITHER_FORCE                    0.02f
#define DITHER_TICKS                    70
// Current Controller
#define CURRENT_CONTROLLER_KP           1.0f
#define CURRENT_CONTROLLER_KI           7500.0f
#define CURRENT_CONTROLLER_I_LIMIT      0.0001f
// Function-likes
#define GET_POSITION()                  ((int)(spi.write(0xFFFF) & 0x1FFF))
#define GET_CURRENT_A()                 (-6.6f*(current_sensor_a.read() - current_sensor_a_offset))
#define GET_CURRENT_B()                 (-6.6f*(current_sensor_b.read() - current_sensor_b_offset))
#define LOWPASSIIR(v,i,w)               v+=w*(i-v)
#define SGN(x)                          (x > 0 ? 1 : (x < 0 ? -1 : 0))
#define ABSPOS()                        (position - position_ref + 8192*position_offset_count)  // dont forget POSITION_RESOLUTION
// Speed estimator
#define SPEED_ESTIMATOR_FAST_GAIN       50
#define SPEED_ESTIMATOR_DEADBAND        1
#define SPEED_ESTIMATOR_FILTER          0.02f
#define SAMPLE_TIME_US                  100
#define SAMPLE_TIME_INVERSE_S           10000.0f

// Current Controller Variables
float       current_sensor_a_offset = 0;
float       current_sensor_b_offset = 0;
// Torque Controller Variables
float       torque = 0;
float       speed;
float       acceleration;
int32_t     position;
int         position_offset_count = 0;
int         position_ref;
int         dither_tick = 0;
// Impedance controller variables
float       ZControl_K  = 0;
float       ZControl_B  = 0;
float       ZControl_I  = 0;
int         ZControl_RefPos = 0;

// IO Variables
//USBHID      hid(16,16);
//HID_REPORT  send_report;
//HID_REPORT  recv_report;
DigitalIn   user_btn(p23);
SPI         spi(NC, p6, p7);  
Serial      pc(USBTX, USBRX);
AnalogIn    current_sensor_a(p15);
AnalogIn    current_sensor_b(p16);
PwmOut      driver_1a(p28);
PwmOut      driver_2a(p27);
PwmOut      driver_1b(p26);
PwmOut      driver_2b(p25);
DigitalOut  driver_enable_a(p34);
DigitalOut  driver_enable_b(p33);
PwmOut      driver_vref_ab(p29);
DigitalOut  info_led_1(LED1);
DigitalOut  info_led_2(LED2);
DigitalOut  info_led_3(LED3);
DigitalOut  info_led_4(LED4);
// Ticker Variables
Ticker      torque_controller;
Ticker      hid_controller;

// Function declarations
void calibrate_current_sensor();
void calibrate_position();
void initialize_io();
void torque_control();
void initialiseer_prbs();
//void hid_control();

#endif