#include "mbed.h"
#include <math.h>

// timer 1
#define LOOPTIME  1000                         // 1 ms
//unsigned long lastMilli = 1000;
unsigned long lastMilli;
// sampling time
//float T = 0.001;
Timer t;
// BT
Serial uart_1(SERIAL_TX, SERIAL_RX);
//Serial uart_1(D10,D2);            // TX : D10     RX : D2           // serial 1
void init_uart(void);
void separate(void);
void uart_send(void);

// uart send data
int display[6] = {0,0,0,0,0,0};
char num[14] = {255,255,0,0,0,0,0,0,0,0,0,0,0,0};      // char num[0] , num[1] : 2 start byte
unsigned long time_flag;
unsigned long uart_flag;
unsigned long Tstart;
unsigned long Tperiod;

// FSR
AnalogIn FSR(A0);
Ticker timer1;
float Voltage_FSR;
void init_TIMER(void);
void timer1_interrupt(void);

// EMG
AnalogIn EMG(A1);
float Voltage_EMG;


int main()
{
    t.start();
    lastMilli = t.read_ms();
    uart_flag = 0;
    Tperiod = 0;
    init_uart();

    // FSR
    init_TIMER();

    while(1) {
        // timer 1
        //flag_time = 0;
//        if((t.read_ms() - lastMilli) >= LOOPTIME)          // 1 ms
//        {
////            flag_time = 1;
//            lastMilli = t.read_us();
//            uart_send();
//            uart_flag = t.read_us() - lastMilli;
//        }
    Tstart = t.read_us();
    uart_send();
    Tperiod = t.read_us()-Tstart;
    Tperiod = Tperiod/10;
    }   // while(1) end
}

int i = 0;
void uart_send(void)
{
    // uart send data
//    display[0] = Gyro_axis_data[0];
    display[0] = Voltage_FSR;
    display[1] = Voltage_EMG;
    display[2] = Tperiod;
    display[3] = 3;
    display[4] = 4;
    display[5] = 5;

//    wait(0.2);
    separate();

    int j = 0;
    int k = 1;
    while(k) {
        if(uart_1.writeable()) {
            uart_1.putc(num[i]);
            i++;
            j++;
        }

        if(j>1) {                   // send 2 bytes
            k = 0;
            j = 0;
        }
    }

    if(i>13)
        i = 0;
}

void init_uart()
{
    uart_1.baud(115200);      // 設定baudrate
}

void separate(void)
{
    num[2] = display[0] & 0x00ff;           // LSB(8bit)資料存入陣列
    num[3] = display[0] >> 8;               // HSB(8bit)資料存入陣列
    num[4] = display[1] & 0x00ff;;
    num[5] = display[1] >> 8;
    num[6] = display[2] & 0x00ff;;
    num[7] = display[2] >> 8;
    num[8] = display[3] & 0x00ff;;
    num[9] = display[3] >> 8;
    num[10] = display[4] & 0x00ff;;
    num[11] = display[4] >> 8;
    num[12] = display[5] & 0x00ff;;
    num[13] = display[5] >> 8;


}
/********************************************************************/
// init_TIMER
/********************************************************************/
void init_TIMER(void)
{
    timer1.attach_us(&timer1_interrupt, 10000);//10ms interrupt period (100 Hz)
//    timer2.attach(&timer2_interrupt, 1);//1s interrupt period (1 Hz)
}

void timer1_interrupt(void)
{
    Voltage_FSR = FSR.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    Voltage_EMG = EMG.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    Voltage_FSR = Voltage_FSR * 33; // Change the value to be in the 0 to 3300 range
    Voltage_EMG = Voltage_EMG * 33; // Change the value to be in the 0 to 3300 range
    time_flag = t.read_ms();
}
