#include "mbed.h"
#include "Mx28.h"
#include "PID.h"

#define SERVO_ID 0x01               // ID of which we will set Dynamixel too 
#define SERVO_ControlPin A2       // Control pin of buffer chip, NOTE: this does not matter becasue we are not using a half to full contorl buffer.
#define SERVO_SET_Baudrate 1000000  // Baud rate speed which the Dynamixel will be set too (1Mbps)
#define TxPin A0
#define RxPin A1
#define CW_LIMIT_ANGLE 1        // lowest clockwise angle is 1, as when set to 0 it set servo to wheel mode
#define CCW_LIMIT_ANGLE 4095       // Highest anit-clockwise angle is 0XFFF, as when set to 0 it set servo to wheel mode
#define PI 3.14159265f

// Timer
Ticker timer1;
float ITR_time = 3000.0;
float Ts = ITR_time/1000000;

// PID
PID motor_pid(7.2, 0, 0, Ts);// 6.4 0.13   7.2 0.13
float PIDout = 0.0f;
// Pin
Serial pc(USBTX, USBRX);
SPI spi(D4, D5, D3); // mosi, miso, sclk
//SPI spi(D11, D12, D13); // mosi, miso, sclk
DigitalOut encoder_cs(D9);
DigitalOut LED(A4);
AnalogIn Value(A5);

//encoder
unsigned short encoder_value = 0;
unsigned short angle = 0;
unsigned short angle_old = 0;
unsigned short angle_init;

// Dynamixel
DynamixelClass dynamixelClass(SERVO_SET_Baudrate,SERVO_ControlPin,TxPin,RxPin);
int servo_cmd;
int row_cmd;
int theta_l;
bool servo_dir;
int omega;
int D_angle_init = 0;
int D_angle = 0;
int D_angle_dif = 0;
float alpha_d = 0.0f;
unsigned short D_angle_cmd = 0;
unsigned short speed = 0;

int Angle = 0;
int Angle_old = 0;

// Acceleration
float acce = 0.0;

// Find Torque
double angle_difference = 0.0;
float torque_measured = 0.0;
float ks = 2.6393*2;  //spring constant
int angle_dif = 0;
float torque_ref = 0.0;
float friction = 0.18f;
//float friction = 0.0f;
float check = 0.0f;
// Mode
DigitalIn button(PC_13);
int step = 0;
float rate = 0.8;
unsigned short alarm = 0;


// TX
union splitter {
    short j;
    char C[2];
    // C[0] is lowbyte of j, C[1] is highbyte of j
};
char T[16] = {255,255,0,0,0,0,0,0,0,0,0,0,0,0};

int i = 0;
int j = 0;
int k = 0;

// Function Declaration
void init_IO();
void init_TIMER();
void timer1_ITR();
void init_UART();
void UART_TX();
void init_SPI();
void init_DYNAMIXEL();
void angle_measured();
void find_torque();
void init_position();
int relative_angle(unsigned int,unsigned int);
void change_mode(void);

int main()
{
    LED = 1;
    wait_ms(500);
    init_IO();
    init_SPI();
    init_UART();
    init_DYNAMIXEL();
    init_position();
    D_angle_init = dynamixelClass.readPosition(SERVO_ID);
    wait_ms(500);
    LED = 0;
    init_TIMER();


    while(1) {
    }
}

void init_IO()
{
    encoder_cs = 1;
}

void init_TIMER()
{
    LED = 1;
    timer1.attach_us(&timer1_ITR, ITR_time); // the address of the function to be attached (timer1_ITR) and the interval (1000 micro-seconds)
    LED = 0;
}

void init_SPI()
{
    spi.format(16,3);
    spi.frequency(1000000);  // 1MHz clock rate
}

void init_UART()
{
    pc.baud(115200);  // baud rate:115200
}
void init_position()
{

//    angle_init = 2038;
    encoder_cs = 0;  // Select the device by seting chip select low

    encoder_value = spi.write(0x00);
    angle_init = encoder_value >> 3;

    encoder_cs = 1;  // Deselect the device
    wait_ms(1000);
}
void init_DYNAMIXEL()
{
    dynamixelClass.torqueMode(SERVO_ID, 1);
    wait_ms(1);
}

void timer1_ITR()
{

    angle_measured();
    find_torque();
    change_mode();
    motor_pid.Compute(torque_ref, torque_measured);
    PIDout = motor_pid.output;
    servo_cmd = PIDout*121.8f;   // 1023/8.4Nm = 121.7857
    if (angle_dif > 0)
        check = 5;
    else
        check = -5;
    if (servo_cmd > 0) {
        servo_cmd = servo_cmd + ((-torque_ref)*rate+friction)*121.8f;
        if (servo_cmd >= 1023)
            servo_cmd = 1023;
    } else {
        servo_cmd = -servo_cmd + 1024 + ((torque_ref)*rate+friction)*121.8f;
        if (servo_cmd >= 2047)
            servo_cmd = 2047;
    }

    if (servo_cmd >= 1023) {
        row_cmd = -(servo_cmd-1023);
    } else {
        row_cmd = servo_cmd;
    }
    dynamixelClass.torque(SERVO_ID, 0);
//    wait_ms(1);
//    speed = dynamixelClass.readSpeed(SERVO_ID);
    UART_TX();
}

void angle_measured()
{
    Angle_old = Angle;

    encoder_cs = 0;  // Select the device by seting chip select low

    encoder_value = spi.write(0x00);
    angle = encoder_value >> 3;

    encoder_cs = 1;  // Deselect the device
    D_angle = dynamixelClass.readPosition(SERVO_ID);

    angle_dif = relative_angle(angle,angle_init);
    D_angle_dif = relative_angle(D_angle,D_angle_init);

    Angle = -(D_angle_dif)+angle_dif;

}

int relative_angle(unsigned int pos,unsigned int init_pos)
{
    int angle_dif;
    angle_dif = pos - init_pos;
    if (angle_dif > 4096/2)
        angle_dif = -(4096-(angle_dif));
    else if (angle_dif < -4096/2)
        angle_dif = -(-4096-(angle_dif));
    else
        angle_dif = angle_dif;

    return angle_dif;
}

void find_torque()
{
    angle_difference = angle_dif/4096.0f*2*PI;
    torque_measured = angle_difference*ks;
}



void UART_TX()
{
    splitter splitter1;
    splitter splitter2;
    splitter splitter3;
    splitter splitter4;
    splitter splitter5;
    splitter splitter6;
    splitter splitter7;

    //數值範圍：-32768~32768
    splitter1.j = row_cmd*100;
    splitter2.j = torque_measured*1000;
//    splitter2.j = D_angle;
    splitter3.j = D_angle;
    splitter4.j = angle;
    splitter5.j = angle_init;
    splitter6.j = angle_dif;
    splitter7.j = 1;

    T[2] = splitter1.C[0];
    T[3] = splitter1.C[1];
    T[4] = splitter2.C[0];
    T[5] = splitter2.C[1];
    T[6] = splitter3.C[0];
    T[7] = splitter3.C[1];
    T[8] = splitter4.C[0];
    T[9] = splitter4.C[1];
    T[10] = splitter5.C[0];
    T[11] = splitter5.C[1];
    T[12] = splitter6.C[0];
    T[13] = splitter6.C[1];
    T[14] = splitter7.C[0];
    T[15] = splitter7.C[1];
    while (1) {
        if (pc.writeable() == 1) {
            pc.putc(T[i]);
            i++;
        }
        if (i>15) {
            i = 0;
            break;
        }
    }
}

void change_mode(void)
{
    if(button.read() == 0) {
        step = 1;
    }
    if(step == 1) {
        torque_ref = -1.0f;
    } else {
        torque_ref = 0;
    }
}