
#include "mbed.h"

DigitalOut LCD_RS(D8);
DigitalOut LCD_EN(D9);
DigitalOut LCD_D4(D4);
DigitalOut LCD_D5(D5);
DigitalOut LCD_D6(D6);
DigitalOut LCD_D7(D7);


//########################################
// LCD Library
//########################################

//send data to lcd
void write_lcd(uint8_t d){

    LCD_D4 = (d & 0x10)?1:0;
    LCD_D5 = (d & 0x20)?1:0;
    LCD_D6 = (d & 0x40)?1:0;
    LCD_D7 = (d & 0x80)?1:0;

    wait_us(2);
    LCD_EN = 1;
    wait_us(2);
    LCD_EN = 0;

}

//lcd write byte
void lcd_write_byte(uint8_t byte){

    write_lcd(byte);
    write_lcd(byte << 4);

}

//write command
void lcd_putcmd(uint8_t c){

    wait_ms(5);
    lcd_write_byte(c);
    
}

//write one char
void lcd_putc(uint8_t d){

    wait_ms(1);
    LCD_RS = 1;
    lcd_write_byte(d);
    LCD_RS = 0;

}



//print string
void lcd_puts(char * p){

    while(* p)lcd_putc(* p++);

}

//lcd initial interface
void lcd_initial(void){
    
    uint8_t x = 3;
    
    LCD_RS = 0;
    LCD_EN = 0;

    LCD_D4 = 0;
    LCD_D5 = 0;
    LCD_D6 = 0;
    LCD_D7 = 0;

    wait_ms(50);
    
    while(x--){
        
        write_lcd(0x30);
        wait_ms(5);
        
    }

    write_lcd(0x20);            //4bit interface

    lcd_putcmd(0x28);           //function set
    lcd_putcmd(0x08);           //display off
    lcd_putcmd(0x01);           //display clear
    lcd_putcmd(0x06);           //entry mode set
    lcd_putcmd(0x0c);           //display on

}
//########################################
// End of LCD Library
//########################################

#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2

Timer tmr;

DigitalInOut data_pin(A1);

int humidity;
int temperature;

//########################################
// DHT11 Library
//########################################
int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_ms(18);
    data_pin.write(1);
    wait_us(40);
    data_pin.input();

    // ACKNOWLEDGE or TIMEOUT
    unsigned int loopCnt = 10000;
    
    while(!data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    loopCnt = 10000;
    
    while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT
    for(int i=0; i<40; i++){
        
        loopCnt = 10000;
        
        while(!data_pin.read())if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        tmr.start();

        loopCnt = 10000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humidity    = bits[0]; 
    temperature = bits[2]; 

    uint8_t sum = bits[0] + bits[2];  

    if(bits[4] != sum)return DHTLIB_ERROR_CHECKSUM;
    
    return DHTLIB_OK;
    
}

char buffer[17];

//########################################
// End of DHT11 Library
//########################################

int main(void){
    
    lcd_initial();
    
    lcd_puts("=Nucleo - DHT11=");
    
    for(;;){
        
        if(!dht_read()){
            
            //sprintf(buffer, "Temp %2d C     ", temperature);
            //lcd_putcmd(0x80);
            //lcd_puts(buffer);
            sprintf(buffer, "Hum %2d%%  Tmp %2dc", humidity, temperature);
            lcd_putcmd(0xc0);
            lcd_puts(buffer);
            wait(0.5);
            
        }else{
            
            lcd_putcmd(0x80);
            lcd_puts("Sensor Error !!!");
            lcd_putcmd(0xc0);
            lcd_puts("                ");
            
        }
    
    }
    
}
