/*
PROGRAMA PARA HACER SEGUIMIENTO DE FLOTAS CON GPS Y CONEXION A LA RED GPRS
se pueden simular trayectorias gravando archivos kml en google earth y usando
SatGen
version 1.0, abril 2019

se asigna un APN segun el servicio GPRS de la SIMCARD
se asigna un nombre de host de su pagina web
se asigna el path de los archivos y mapas ejecutables en su servidor
se asigna un ciclo de repeticion de lecturas de GPS.

*/

#include "mbed.h"
#include "stdio.h"
#include "string.h"
#include "GPS.h"

Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
InterruptIn button(PTA13);


float lo,la;
char lon[15], lat[15]; // Cadenas a capturar para latitud y longitud.
char gprsBuffer[20];
char resp[15];
Serial GSM(PTE0,PTE1);  // Puertos del FRDM para el Módem.
Serial pc(USBTX,USBRX);
GPS gps(PTE22, PTE23);   // Puerto del FDRM para el GPS.
int result;
int z=0;
int i=0;
int count=0;
int g=0;

//-----------------------------------------------------------------------------------------------------------------------------
// Esta funcion de abajo lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de
// $, count es lo que va a leer. Lo leido lo mete en buffer que es una cadena previamente definida
// incorpora medida de tiempo si se demora mas de tres segundos retorna fracaso con -1
int readBuffer(char *buffer,int count){
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()){  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}
//--------------------------------------------------------------------------------------------------------------
// Esta función de abajo limpia o borra todo un "buffer" de tamaño "count",
// lo revisa elemento por elemento y le mete el caracter null que indica fin de cadena.
// No retorna nada.
void cleanBuffer(char *buffer, int count){
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

//--------------------------------------------------------------------------------------------------------------
// Esta función de abajo envia un comando parametrizado como cadena
// puede ser un comando tipo AT.
void sendCmd(char *cmd){
    GSM.puts(cmd);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Esta función de abajo espera la respuesta de un comando que debe ser idéntica a la cadena "resp" y un tiempo "timeout",
// si todo sale bien retorna un cero que en la programacion hay que validar,
// si algo sale mal (no se parece o se demora mucho) retorna -1 que debera validarse con alguna expresion logica.
int waitForResp(char *resp, int timeout){
    int len = strlen(resp);
    int sum=0;
    t.start();
 
    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Esta función de abajo es muy completa y útil, se encarga de enviar el comando y esperar la respuesta.
// Si todo sale bien retorna un cero (herencia de las funciones contenedoras) que en la programacion hay que validar
// con alguna expresion lógica.
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout){
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Esta función de abajo chequea que el módem este vivo, envia AT, le contesta con OK y espera 2 segundos.
int powerCheck(void){ // Este comando se manda para verificar si el módem esta vivo o conectado.
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Esta función de abajo chequea el estado de la sim card
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int checkSIMStatus(void){
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer, 30);
    while(count < 3){
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))){
            break;
        }
        count++;
        wait(1);
    }
 
    if(count == 3){
        return -1;
    }
    return 0;
}
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

// Esta función de abajo chequea la calidad de la señal
// y si todo sale bien retorna con el valor de señal útil o un -1 si no es aceptable, en la programacion hay que validar
// con alguna expresión lógica.
int checkSignalStrength(void){
    char gprsBuffer[100];
    int index, count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3){
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3){
        return -1;
    }
    return index;
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//   detectar  direcion ip
int ip_detect(){
        if (GSM.readable()){
        readBuffer(gprsBuffer,15);
            for(i=0;i<15;i++)
            {
            resp[i]=gprsBuffer[i];
            }  
            cleanBuffer(gprsBuffer,20);
            for(i=0;i<15;i++){
               if(resp[i]== '.'){
               z++;
                                }
                              }
            if(z==3){   //CUENTO TRES PUNTOS LO MAS PROBABLE ES QUE SEA UNA DIRECCION ip
                    pc.printf("llego ip=%d\r\n",z);
                    z=0;
                    return 0;  //RETORNA CON CERO SI LLEGARON TRES PUNTOS
                    } 
        }//fin check GSM modem         
        z=0;
        return -1;  //NO LLEGARON 3 PUNTOS RETORNA CON -1
        }//fin funcion
        
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
// Esta funcion de abajo inicia la comunicacion GPRS con la red celular, Se compone de un grupo de subfunciones ya definidas previamente
// envia las secuencias de forma ordenada esparando la respuesta adecuada
// si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
//*********************************************************************************************************

int init_gprs(void){
        
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 3)){
        return -1;
    }
     if (0 != sendCmdAndWaitForResp("ATE0\r\n", "OK", 3)){  //sin eco
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CGATT=1\r\n", "OK", 3)){//inicia conexion GPRS
        pc.printf("conectamos al servidor de CLARO");
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CSTT=internet.comcel.com.co,comcel,comcel \r\n", "OK", 3)){ //set apn
        pc.printf("consulte su respectivo APN");
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CIICR\r\n", "OK", 3)){ //habilitar conexion inalambrica
        pc.printf("hablita conexion inalabrica");
        return -1;
    }
    
    cleanBuffer(gprsBuffer,25);
    sendCmd("AT+CIFSR\r\n"); //obtener direccion ip
    if(0 != ip_detect()){  //esperar la llegada de un direccion IP
        pc.printf("Llego ip");
        return -1;
    }    
    wait(1);    
    LedVerde=0;//CONEXION OK... PRENDE LED VERDE..
    return 0;
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//ESTA FUNCION DE ABAJO CIERRA UNA CONEXION GPRS

int end_gprs(void){
    if (0 != sendCmdAndWaitForResp("AT+CIPSHUT\r\n", "OK", 3)){
        pc.printf("Desconectando GPRS");
        return -1;
    }
     if (0 != sendCmdAndWaitForResp("AT+CGATT=0\r\n", "SHUT OK", 3)){  
        return -1;
    }
    LedVerde=0;
    LedRojo=1;
    return 0;
  }
  
//++++++++++++++++++++++++++++++++++++++++++++++++++++
//interupcion perdida de energia
//++++++++++++++++++++++++++++++++++++++++++++++++++++

void off_gprs(){
      end_gprs();
      }   

//+++++++++++++++++++++++++++++++++++++++++++++++++++++
//inicio del programa principal
//+++++++++++++++++++++++++++++++++++++++++++++++++++++
int main(){

loop1:g=gps.sample(); //GPS bien conectado????  de primero antes que todo!!!!
      if(g){
        LedAzul=0;//prende led azul GPS ok!!!
        pc.printf("GPS--OK\n\r");
        //si no hay GPS no intentar dada, ni conexion ni envio de datos y esperar el GPS
        goto lop1;
        }
       goto loop1;  //chequeo infinito de un GPS bien instalado...

lop1:
     
    if(init_gprs()<0){
        LedRojo=0;//PRENDE ROJO, APAGA VERDE       
        LedVerde=1;
         goto lop1;//NO SE PUEDE RECONECTAR INFINITAMENTE ESTE SALTO ES PROVISIONAL
        //CONTAR LOS INTENTOS Y DAR SEÑAL DE ERROR PERMANENTE
        //}
        button.fall(&off_gprs);//perdida de alimentacion,apagaron carro  ejecuta interupcion
        //que desconecta la conexion GPRS
    while(1){  //si el GPS tiene conexion y datos se envian coordenadas a pagina web
           LedAzul=1;
           if(gps.sample()){
                        LedAzul=0;
                        lo = gps.longitude;
                        la = gps.latitude;
                        sprintf (lon, "%f", lo);//pasa de flotante a caracter
                        sprintf (lat, "%f", la);//pasa de flotante a caracter
                        GSM.printf("AT+CIPSTART=\"TCP\",\"unrobotica.com\",\"80\"\r\n");///Se pusieron las doble comillas
               //repetir1:if (0 != sendCmdAndWaitForResp("AT+CIPSTART=\"TCP\",\"unrobotica.com\",\"80\"\r\n","OK", 3)){
                        //wait(3);
                        //LedVerde=1;
                        //LedRojo=0;
                        //goto repetir1;//salto provisional debe contar intentos y no hacer nada ya que es imposible conectarse
                        //} 
                            
               repetir2:cleanBuffer(gprsBuffer,10);
                        if(0 !=sendCmdAndWaitForResp("AT+CIPSEND\r\n","",3)){  //devuelve control+Z
                        wait(1);
                        goto repetir2;//salto provisional debe contar intentos y no hacer nada ya que es imposible conectarse
                        }
                        
                        GSM.printf("GET /gpstracker/gps1.php?lat=%s&lon=%s HTTP/1.1\r\n",lat,lon);
                        wait(5);
                        
                        GSM.printf("Host: unrobotica.com\n\n");
                        wait(5);
                        pc.printf("Conectadno a Unrobotica \n");
                        wait(5);
                        GSM.printf("\r\n");
                        if(0 !=sendCmdAndWaitForResp("\n\r","SEND OK",10))
                        {
                         
                        }
                         //mas tarde  devuelve SEND OK ...esto es suficiente para indicarnos que los datos se fueron a la nube
                        //cleanBuffer(gprsBuffer,20);
                        //leer bufer y encontrar respuesta exitosa  devuelve "SEND OK"
                                          
                        //readBuffer(gprsBuffer,10);
                        //if((NULL = strstr(gprsBuffer,""))){
                        //  wait(1);
                        //  goto repetir2;
                        LedRojo=1;
                        LedVerde=0; //envio OK
                        }// del test del gps
                        LedRojo=0;   // hay problemas
                        LedVerde=1; 
                         
            }//del while col 13
               
          }//del main col 11
             
 
         

}  