#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC
DigitalIn CTS(p7, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalOut RTS(p8, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
Serial device(p9, p10, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
int flag=1;                         // Declaración de la Bandera.
int incomingByte=0;
Thread thread;

void respuesta(){
    while(1){
    if(device.readable()) {         // Se esperan datos provenientes del TX del módulo STX3
           incomingByte=device.getc();
            //pc.putc(num);
            pc.printf("%X",incomingByte);
            pc.printf(" ");
           // pc.putc(device.getc());     // Se muestra en pantalla la respuesta recibida por el módulo STX3 como una reacción al mensaje en HEX enviado
            }
            }
    }

void stx3()
    {
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1){             // Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
        }
    }
        
int main() { 
    thread.start(respuesta);
       
        while(1) {
        
        switch (pc.getc())
        {
        case '1':
            {
            led1=!led1;
            pc.printf("\n\rQuery ESN AA 05 01 50 D5\n\r");
            stx3();
            Thread::wait(10);               // Query ESN
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X01);
            device.putc(0X50);
            device.putc(0XD5);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;         
            }
            break;  
            
        case '2':
            {
            led2=!led2;
            pc.printf("\n\rQuery Burst Remaining AA 05 04 FD 82\n\r");
            stx3();
            Thread::wait(10);                // Query Bursts Remaining
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X04);
            device.putc(0XFD);
            device.putc(0X82);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
        case '3':
            {
            led3=!led3;
            pc.printf("\n\rQuery Firmware Version AA 05 05 74 93\n\r");
            stx3();
            Thread::wait(10);                // Query Firmware Version
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X05);
            device.putc(0X74);
            device.putc(0X93);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
        case '4':
            {
            led4=!led4;
            pc.printf("\n\rQuery SETUP AA 05 07 66 B0\n\r");
            stx3();
            Thread::wait(10);                // Query SETUP
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X07);
            device.putc(0X66);
            device.putc(0XB0);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
             case '5':
            {
            led1=!led1;
            pc.printf("\n\rQuery Hardware Version AA 05 09 18 59\n\r");
            stx3();
            Thread::wait(10);                // Query Hardware Version
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X09);
            device.putc(0X18);
            device.putc(0X59);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
             case '6':
            {
            led2=!led2;
            pc.printf("\n\rNAK AA 05 07 66 B1\n\r");
            stx3();
            Thread::wait(10);                // Manda error NAK
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X07);
            device.putc(0X66);
            device.putc(0XB1);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
            case '7':
            {
            led3=!led3;
            pc.printf("\n\rSETUP AA 0E 06 00 00 00 00 00 03 18 30 00 CE 9C\n\r");
            stx3();
            Thread::wait(10);                // SETUP
            device.putc(0XAA);      
            device.putc(0X0E);
            device.putc(0X06);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X03);
            device.putc(0X18);
            device.putc(0X30);
            device.putc(0X00);
            device.putc(0XCE);
            device.putc(0X9C);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
            case '8':
            {
            led4=!led4;
            pc.printf("\n\rSend Data AA 0E 00 01 02 03 04 05 06 07 08 09 BE E8\n\r");
            stx3();
            Thread::wait(10);                // SEND DATA
            device.putc(0XAA);      
            device.putc(0X0E);
            device.putc(0X00);
            device.putc(0X01);
            device.putc(0X02);
            device.putc(0X03);
            device.putc(0X04);
            device.putc(0X05);
            device.putc(0X06);
            device.putc(0X07);
            device.putc(0X08);
            device.putc(0X09);
            device.putc(0XBE);
            device.putc(0XE8);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
            
            case '9':
            {
            led1=!led1;
            pc.printf("\n\rAbort Transmission AA 05 03 42 F6\n\r");
            stx3();
            Thread::wait(10);                // Abort Transmission
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X03);
            device.putc(0X42);
            device.putc(0XF6);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
            case 'A':
            {
            led2=!led2;
            pc.printf("\n\rSend Data for PDR\n\r");
            stx3();
            Thread::wait(10);                // SEND DATA
            device.putc(0XAA);      
            device.putc(0X65);
            device.putc(0X00);
            device.putc(0X41);
            device.putc(0X6E);
            device.putc(0X64);
            device.putc(0X72);
            device.putc(0X65);
            device.putc(0X73);
            device.putc(0X20);
            device.putc(0X4D);
            device.putc(0X61);
            device.putc(0X72);
            device.putc(0X74);
            device.putc(0X69);
            device.putc(0X6E);
            device.putc(0X65);
            device.putc(0X7A);
            device.putc(0X20);
            device.putc(0X4E);
            device.putc(0X41);
            device.putc(0X53);
            device.putc(0X41);
            device.putc(0X0D);
            device.putc(0X0A);
            device.putc(0X43);
            device.putc(0X61);
            device.putc(0X72);
            device.putc(0X6C);
            device.putc(0X6F);
            device.putc(0X73);
            device.putc(0X20);
            device.putc(0X44);
            device.putc(0X75);
            device.putc(0X61);
            device.putc(0X72);
            device.putc(0X74);
            device.putc(0X65);
            device.putc(0X20);
            device.putc(0X41);
            device.putc(0X45);
            device.putc(0X4D);
            device.putc(0X0D);
            device.putc(0X0A);
            device.putc(0X45);
            device.putc(0X75);
            device.putc(0X67);
            device.putc(0X65);
            device.putc(0X6E);
            device.putc(0X69);
            device.putc(0X6F);
            device.putc(0X20);
            device.putc(0X55);
            device.putc(0X72);
            device.putc(0X72);
            device.putc(0X75);
            device.putc(0X74);
            device.putc(0X69);
            device.putc(0X61);
            device.putc(0X20);
            device.putc(0X55);
            device.putc(0X50);
            device.putc(0X41);
            device.putc(0X45);
            device.putc(0X50);
            device.putc(0X0D);
            device.putc(0X0A);
            device.putc(0X46);
            device.putc(0X65);
            device.putc(0X62);
            device.putc(0X72);
            device.putc(0X75);
            device.putc(0X61);
            device.putc(0X72);
            device.putc(0X79);
            device.putc(0X20);
            device.putc(0X32);
            device.putc(0X30);
            device.putc(0X74);
            device.putc(0X68);
            device.putc(0X20);
            device.putc(0X32);
            device.putc(0X30);
            device.putc(0X31);
            device.putc(0X38);
            device.putc(0X0D);
            device.putc(0X0A);
            device.putc(0X50);
            device.putc(0X44);
            device.putc(0X52);
            device.putc(0X20);
            device.putc(0X61);
            device.putc(0X70);
            device.putc(0X70);
            device.putc(0X72);
            device.putc(0X6F);
            device.putc(0X76);
            device.putc(0X65);
            device.putc(0X64);
            device.putc(0XC8);
            device.putc(0X16);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            }
        }
        
        
    }
                           
