#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"
#include <string>

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC
DigitalIn CTS(p7, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalOut RTS(p8, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.
Serial device(p9, p10, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
int flag=1;                         // Declaración de la Bandera.
int incomingByte=0;
Thread thread;
AnalogIn   ain(p20);
void waitCTS();

uint16_t ModRTU_CRC(char * buf, int len)
{
  unsigned char i;
  unsigned short data;
  uint16_t crc = 0xFFFF;
 
  do{
    data = (unsigned int)0x00FF & *buf++;
    crc = crc ^ data;

    for(i = 8; i > 0; i--)
    {
      if(crc & 0x0001)
        crc = (crc >> 1) ^ 0x8408;
      else
        crc >>=1;  
    }
    
  }while (--len);
  
  crc = ~crc;
  
  // Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)
  return (crc);  
}


void respuesta(){
    while(1){
    if(device.readable()) {         // Se esperan datos provenientes del TX del módulo STX3
           incomingByte=device.getc();
            //pc.putc(num);
            pc.printf("%X",incomingByte);
            pc.printf(" ");
           // pc.putc(device.getc());     // Se muestra en pantalla la respuesta recibida por el módulo STX3 como una reacción al mensaje en HEX enviado
            }
            }
    }

void stx3()
    {
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1){             // Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
        }
    }
        
int main() { 
    thread.start(respuesta);
     
        while(1) {
        
        float voltage = 3300*ain.read();
       
        if(voltage == 0)
  {
    printf("Fault");
  }
  else if(voltage < 400)
  {
    printf("preheating");
  }
  
  else
  {  
       int voltage_diference=voltage-400;
       int c=voltage_diference*50.0/16.0;
       
        printf("voltage es: %f mV \n", voltage);
        
        printf("concentracion de C02 en ppm es: %X \n", c);
        
        stx3();
         int number = 5;
         printf("%d\n",number);
         char header[3] = {0xAA,0x07,0x00};  //Define header information
         char vec[number];
         uint8_t c1=c;
         uint8_t c2=c>>8;
          
         
         
         for(int k = 0; k < 3; k++)
        vec[k] = header[k];
        
        vec[3] =c2;
        vec[4] =c1;
        
        
        
       
    pc.printf("Command(HEX):\t\t");
    //Print b characters in HEX
    for(int k = 0; k < number; k++)   
        pc.printf("%X ",vec[k]); 
        
    char *t = (char *)vec;    //a
    char crc1 = ModRTU_CRC(t,t[1]-2)&0xFF;
    char crc2 = ModRTU_CRC(t,t[1]-2)>>8;
    
    pc.printf("%X ",crc1); //%X print char in HEX format
    pc.printf("%X ",crc2); //%X print char in HEX format
    
    for(int k = 0; k < number; k++)
        device.putc(vec[k]);
    device.putc(crc1);
    device.putc(crc2);  
    
    Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;         
    
    
        
    }   
        wait(1);
        
        switch (pc.getc())
        {
        case '1':
            {
            led1=!led1;
            pc.printf("\n\rQuery ESN AA 05 01 50 D5\n\r");
            stx3();
            Thread::wait(10);               // Query ESN
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X01);
            device.putc(0X50);
            device.putc(0XD5);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;         
            }
            break;  
            
        case '2':
            {
            led4=!led4;
            pc.printf("\n\rQuery SETUP AA 05 07 66 B0\n\r");
            stx3();
            Thread::wait(10);                // Query SETUP
            device.putc(0XAA);      
            device.putc(0X05);
            device.putc(0X07);
            device.putc(0X66);
            device.putc(0XB0);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
        case '3':
            {
            led3=!led3;
            pc.printf("\n\rSETUP AA 0E 06 00 00 00 00 00 03 01 03 00 8F 19 \n\r");
            stx3();
            Thread::wait(10);                // SETUP
            device.putc(0XAA);      
            device.putc(0X0E);
            device.putc(0X06);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X00);
            device.putc(0X03);
            device.putc(0X01);
            device.putc(0X03);
            device.putc(0X00);
            device.putc(0X8F);
            device.putc(0X19);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
        case '4':
            {
            led4=!led4;
            pc.printf("\n\r Send Data AA 07 00 FF FF 82 CE \n\r");
            stx3();
            Thread::wait(10);                // Query SETUP
            device.putc(0XAA);      
            device.putc(0X07);
            device.putc(0X00);
            device.putc(0XFF);
            device.putc(0XFF);
            device.putc(0X82);
            device.putc(0XCE);
            Thread::wait(10);                // Se esperan .1 segundos una vez que se terminaron de hacer las transmisiones
            //El tiempo total de transmisión es; el wait previo a las transmisiones, el tiempo que tarda el Mu en enviar los datos y el wait posterior a la transmisión
            RTS=1;
            Thread::wait(150);
            pc.printf("\n\rCTS: %d\n\r",CTS.read());
            flag=1;               
            }
            break;
            
}
}
}

void waitCTS()
{
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    //pc.printf("El valor de CTS es %d\n\r",CTS.read());        // Se lee el valor de la variable CTS, la cual debe ser 1
    //pc.printf("El valor de RTS es %d\n\r",RTS.read());        // Se lee el valor de la variable RTS, la cual debe ser 1
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    
    while(flag==1)
    {// Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
        //pc.printf("El valor de flag es %d\n\r", flag);    // Se imprime el valor de flag, para identificar cuando termina el ciclo while
    }
}

void sendData()
{
    led4=!led4;
    waitCTS();
    Thread::wait(10);  
    
    }
    
