#define DATA_PIN        PTE20
#define MAX_PROBES      16
#include "mbed.h"
#include "DS1820.h"
#include "Display16.h"
#include "SETdata_TSI.h"
#include "ME_Compresor.h"
#include "ME_Ventilador.h"
#include "ME_Alarma.h"
void __interruptDisplay(void);
void __interruptSETData(void);
void __Alarma(void);

unsigned char VSet=4;
unsigned char TRet=0;
unsigned int var_alarma=0;
unsigned int alarmav=0;
Ticker display;
DS1820* probe[MAX_PROBES];
Ticker SetData;
Ticker Alarma;
float promedio,t1,t2,t1r,t2r;
int main()
{
    int num_devices = 0;
    while(DS1820::unassignedProbe(DATA_PIN)) {
        probe[num_devices] = new DS1820(DATA_PIN);
        num_devices++;
        if (num_devices == MAX_PROBES)
            break;
    }
    printf("Found %d device(s)\r\n\n", num_devices);
    display.attach(&__interruptDisplay,0.003);
    SetData.attach(&__interruptSETData,0.1);
    Alarma.attach(&__Alarma,0.1);
    while(1) {
        probe[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        t1r=probe[0]->temperature();
        t2r=probe[1]->temperature();
        if(t1r>0) t1=t1r;
        if(t2r>0) t2=t2r;
        promedio=((t1/3*10)+(t2/3*10))/2;
        for (int i = 0; i<num_devices; i++) {
            printf("Device %d returns %3.1foC\r\n", i, probe[i]->temperature());
            printf("\r\n");
        }
        ME_Ventilador(t1,t2);
        ME_Compresor(VSet,promedio);
        ME_Alarma(var_alarma);
        
    }
}

void __interruptDisplay ()
{
    if(ME_Alarma_estado==A_on)alarmav=1;
    else alarmav=0;
    display16(TRet,VSet,promedio,alarmav);
}
void __interruptSETData (void)
{
    VSet=SETData();
    TRet=RetainData();
}

void __Alarma()
{
    if(ME_Alarma_estado==espera && var_alarma>0) {
        var_alarma--;
    }
}