#include "ST7920Libreries.h"
#include "mbed.h"
#include "st7920.h"
#include "Tipografia5x3.h"

unsigned char a='a';
unsigned char RAM[17]= {0};
//DigitalOut myLCD_RS(PTB0);
ST7920 myLCD (PTC5/*RS*/,PTC4/*RW*/, PTC3/*Enable*/, PTD4/*D0*/, PTA12/*D1*/, PTA4/*D2*/, PTA5/*D3*/, PTC8/*D4*/, PTC9/*D5*/, PTC11/*D6*/, PTC10/*D7*/);
Serial pc(USBTX,USBRX);

void point(unsigned char x, unsigned char y, unsigned char cruze)
{
    unsigned int punto=0;
    myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (y % 32)) ;
    if((y/32) == 0 ) {
        myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (x/16)) ;
    } else {
        myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (0x08 | (x/16))) ;
    }
    RAM[0]=myLCD.ReadRAM();
    RAM[0]=myLCD.ReadRAM();
    RAM[1]=myLCD.ReadRAM();
    myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (y % 32)) ;
    if((y/32) == 0 ) {
        myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (x/16)) ;
    } else {
        myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | (0x08 | (x/16))) ;
    }
    punto = 0xFFFF & (0x8000 >> (x%16));
    if(cruze==1) {
        myLCD.WriteRAM((punto & 0xFF00) >> 8 | RAM[0]);
        myLCD.WriteRAM(punto & 0x00FF | RAM[1]);
    } else if(cruze==0) {
        myLCD.WriteRAM((punto & 0xFF00) >> 8 ^ RAM[0]);
        myLCD.WriteRAM(punto & 0x00FF ^ RAM[1]);
    }
}
void CLRpoint(unsigned char x, unsigned char y)
{
    point(x,y,1);
    point(x,y,0);
}
void Hline(unsigned char x1,unsigned char y,unsigned char x2, unsigned char cruze)
{
    for(unsigned int i = x1; i <= x2 ; i++) {
        point(i,y,cruze);
    }
}
void Vline(unsigned char y1,unsigned char x,unsigned char y2, unsigned char cruze)
{
    for(unsigned int i = y1; i <= y2 ; i++) {
        point(x,i,cruze);
    }
}
void CLRHline(unsigned char x1,unsigned char y,unsigned char x2)
{
    for(unsigned int i = x1; i <= x2 ; i++) {
        CLRpoint(i,y);
    }
}
void CLRVline(unsigned char y1,unsigned char x,unsigned char y2)
{
    for(unsigned int i = y1; i <= y2 ; i++) {
        CLRpoint(x,i);
    }
}
void FULLScreen()
{
    unsigned char i, j, k ;

    for ( i = 0 ; i < 2 ; i++ ) {
        for ( j = 0 ; j < 32 ; j++ ) {
            myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | j) ;
            if ( i == 0 ) {
                myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS) ;
            } else {
                myLCD.WriteInstruction(SET_GRAPHIC_RAM_ADDRESS | 0x08) ;
            }
            for ( k = 0 ; k < 8 ; k++ ) {
                myLCD.WriteRAM(0xFF);
                myLCD.WriteRAM(0xFF);
            }

        }
    }
}

void CLRScreen()
{
    myLCD.ClearGDRAM();
}

void linea(float x1 , float y1 , float x2 , float y2, const char cruze)
{
    float dx , dy , pend;
    unsigned char y = 0;
    dx=x2-x1;
    dy=y2-y1;
    pend= dy / dx;
    for(unsigned char i = 0 ; i <= dx ; i++) {
        y = y1 + (pend * i);
        point((i+x1) , y , cruze);
    }

}
void CLRlinea(float x1 , float y1 , float x2 , float y2)
{
    float dx , dy , pend;
    unsigned char y = 0;
    dx=x2-x1;
    dy=y2-y1;
    pend= dy / dx;
    for(unsigned char i = 0 ; i <= dx ; i++) {
        y = y1 + (pend * i);
        CLRpoint((i+x1) , y);
    }

}
void text(int x, int y, const char str[],unsigned char strlen, unsigned char cruze)
{
    for(unsigned int i=0; i<=strlen; i++) {
        Tipografia5x3(x, y, str[i],i,1);
    }
}
void init()
{
    myLCD.InitDisplay();
    myLCD.SetGraphicsMode();
    myLCD.ClearGDRAM();
}
void DivisionesEjeY(int inicio,unsigned int espaciado,unsigned int cant, unsigned int y, unsigned int largo, unsigned char cruze)
{
    for(unsigned int i=0; i<=cant; i++) {
        Hline(y-(largo/2) , (i*espaciado)+inicio , y+(largo/2),cruze);
    }
}
void DivisionesEjeX(int inicio,unsigned int espaciado,unsigned int cant, unsigned int x, unsigned int largo, unsigned char cruze)
{
    for(unsigned int i=0; i<=cant; i++) {
        Vline(x-(largo/2) ,(i*espaciado)+inicio , x+(largo/2),cruze);
    }
}
void TextoEjeY(unsigned char modo, unsigned char cruze)
{
    /*Texto en eje Y(dB)*/
    if(modo == modulo) {
        text(2,4,"60",2,cruze);//60
        text(2,14,"40",2,cruze);//40
        text(2,24,"20",2,cruze);//20
        text(6,38,"0",1,cruze);//0
        text(-1,44,"-20",3,cruze);//-20
        text(-1,54,"-40",3,cruze);//-40
        text(-1,63,"-60",3,cruze);//-60
        text(13,4,"dB",2,cruze);//dB
    } else if(modo == fase) {
        text(3,4,"180",2,cruze);//60
        text(3,14,"120",2,cruze);//40
        text(3,24,"60",2,cruze);//20
        text(6,38,"0",1,cruze);//0
        text(-1,44,"-60",3,cruze);//-20
        text(-1,54,"-120",3,cruze);//-40
        text(-1,63,"-180",3,cruze);//-60
    }
}
void TextoEjeX(unsigned char cruze)
{
    /*Texto en eje X(frecuencia)*/
    text(26,38,"10",2,cruze);//10
    text(43,38,"100",3,cruze);//100
    text(64,38,"1K",2,cruze);//1K
    text(81,38,"10K",3,cruze);//10K
    text(98,38,"100K",4,cruze);//100K
    text(121,38,"1M",2,cruze);
    //text(117,40,"f",1,cruze);//f
}
void flechaY(int x,int y, const char dir ,unsigned char cruze)
{
    if(dir==1) {
        for(unsigned int i=0; i<=4; i++) {
            point(x,y+2-i,cruze);
        }
        for(unsigned int i=0; i<=2; i++) {
            point(x+1,y+1-i,cruze);
        }
        point(x+2,y,cruze);
    } else if(dir==0) {
        for(unsigned int i=0; i<=4; i++) {
            point(x,y+2-i,cruze);
        }
        for(unsigned int i=0; i<=2; i++) {
            point(x-1,y+1-i,cruze);
        }
        point(x-2,y,cruze);
    }
}
void Cuadrado(int x1, int x2, int y1, int y2,const char cruze)
{
    Hline(x1,y1,x2,cruze);
    Hline(x1,y2,x2,cruze);
    Vline(y1,x1,y2,cruze);
    Vline(y1,x2,y2,cruze);
}
void CuadradoRelleno(int x1, int x2, int y1, int y2,const char cruze)
{
    for(unsigned int i=x1; i<x2; i++) {
        Vline(y1,i,y2,1);
    }
}

