#include "mbed.h"
#define PT_CLK PTC0
#define PT_DATA PTC7
#define PT_BCD0 PTC5
#define PT_BCD1 PTC4
#define PT_BCD2 PTC3
#define PT_PUNTO PTB0
#define C 11
#define H 12
#define I 13
#define G 14
#define P 15

DigitalOut CLK(PT_CLK);
DigitalOut DATA(PT_DATA);
DigitalOut BCD0(PT_BCD0);
DigitalOut BCD1(PT_BCD1);
DigitalOut BCD2(PT_BCD2);
DigitalOut PUNTO(PT_PUNTO);
unsigned char t = 0;
unsigned char StoreData=0;

void display16(unsigned char var_RetainData, unsigned char tempSeteada,unsigned char tempMedida,unsigned int alarma)
{
    unsigned char k = 0;
    unsigned int n[4] = {1,2,10,11};
    unsigned long Disp[16] = {
        /*numeros:*/
        /*0*/0b1111110110000000,
        /*1*/0b0011000000000000,
        /*2*/0b1110110100010010,
        /*3*/0b1111110000010010,
        /*4*/0b0011000010010010,
        /*5*/0b1101110010010010,
        /*6*/0b1101110110010010,
        /*7*/0b1111000000000000,
        /*8*/0b1111110110010010,
        /*9*/0b1111000010010010,
        /*simbolos*/
        /*º*/0b0110000001010000,
        /*letras*/
        /*C*/0b1100110110000000,
        /*H*/0b0011000110010010,
        /*I*/0b1100110001000100,
        /*G*/0b1101110110010000,
        /*P*/0b1110000110010010
    };
    /*0/g1/!/0/g2/0/¡/f/e/0/d2/d1/c/b/a2/a1*/
    BCD2 = 0;
    if(var_RetainData != 0) {
        n[0] = tempSeteada / 10;
        n[1] = tempSeteada - (n[0] * 10);
    }
    else{
    if(tempMedida!=0) {
        StoreData=tempMedida;
    }
    if(StoreData<100) {
        n[0] = StoreData / 10;
        n[1] = StoreData - (n[0] * 10);
        PUNTO=0;
    } else if(StoreData>=100) {
        n[0]= H;
        n[1]= I;
        n[2]= G;
        n[3]= H;
        PUNTO=1;
    }}
    if(alarma==1){
        n[0]= P;
        n[1]= I;
        n[2]= I;
        n[3]= P;
        PUNTO=1;
        }
    for(k = 0; k < 16; k++) {
        DATA=(Disp[n[t]] >> (15 - k)) & 1;
        CLK = 1;
        CLK = 0;
    }
    BCD0 = t & 1;
    BCD1 = (t & 2)>>1;
    t++;
    if(t >= 4)t = 0;
}

