/*
 * tpm.c
 *
 *  Created on: Jul 16, 2013
 *      Author: B34443
 */

#include "MKL25Z4.h"
#include "tpm.h"

int TPM_init_IC(TPM_Type* TPMx, int  clock_source, int modulo, int clock_mode, int ps)
{
    int val = 1;
    int i;
    
    if (TPMx == TPM0)
        SIM->SCGC6   |= SIM_SCGC6_TPM0_MASK;
    else if (TPMx == TPM1)
        SIM->SCGC6 |= SIM_SCGC6_TPM1_MASK;
    else
        SIM->SCGC6 |= SIM_SCGC6_TPM2_MASK;
    
    /* 0: disabled
     * 1: MCGFLLCLK or MCGFLLCLK/2
     * 2: OSCERCLK
     * 3: MCGIRCLK */
    SIM->SOPT2   |= SIM_SOPT2_TPMSRC(clock_source);
    
    TPMx->MOD   =  modulo;
    
    //TOIE: overflow interrupt enable
    TPMx->SC    = TPM_SC_TOIE_MASK | TPM_SC_CMOD(clock_mode) | TPM_SC_PS(ps);
    
    i = ps;
    
    while(i--)
    {
        val += val;
    }
    
    val=(SystemCoreClock/2)/val;
    
    return val;
}

void TPM_CLK_MODE (TPM_Type* TPMx, int clock_mode)
{
    int temp;
    temp = TPMx->SC;
    temp &= ~TPM_SC_CMOD(3);
    temp |= TPM_SC_CMOD(clock_mode);
    TPMx->SC =  temp;
}


void TPM_clear_counter(TPM_Type* TPMx)
{
    TPMx->CNT = 0;
}

void TPM_CH_init(TPM_Type* TPMx, int channel, int mode)
{
    TPMx->CONTROLS[channel].CnSC = mode | TPM_CnSC_CHIE_MASK;
}


