#include "hal.h"
#include "pinmap.h"
#include "tpm.h"

/* lowest timer clock is 48e6 / 128 = 375khz  */

#define TPM_MODULUS    0xFFFF

volatile uint32_t tx_pin_captured_value;
volatile uint32_t prev_rx_pin_captured_value;
volatile uint32_t rx_pin_captured_value;

volatile char new_tx_value; // flag tx falling
volatile char new_rx_value;  // flag rx rising

static uint32_t hal_tick;   /* make the timer effectively 32bit */

/* J10-1 PTE20 TPM1_CH0 (RX rising-edge and 1PPS)
 * J10-3 PTE21 TPM1_CH1 (TX falling-edge)
 */

void tpm1_isr()
{
    if (TPM1->CONTROLS[0].CnSC & TPM_CnSC_CHF_MASK) {
        prev_rx_pin_captured_value = rx_pin_captured_value;
        rx_pin_captured_value = TPM1->CONTROLS[0].CnV | hal_tick;
        TPM1->CONTROLS[0].CnSC |= TPM_CnSC_CHF_MASK;
        new_rx_value = 1;
        /*HOLA=1;
        HOLA=0;*/
    }
    
    if (TPM1->CONTROLS[1].CnSC & TPM_CnSC_CHF_MASK) {
        tx_pin_captured_value = TPM1->CONTROLS[1].CnV | hal_tick;
        TPM1->CONTROLS[1].CnSC |= TPM_CnSC_CHF_MASK;
        new_tx_value = 1;
    }
    
    if (TPM1->SC & TPM_SC_TOF_MASK) {   /* 16bit overflow */
        TPM1->SC |= TPM_SC_TOF_MASK;
        hal_tick += 0x10000;
    }
}

int capture_init(void)
{   
    pin_function(PTE20, 3);  // 3: TPM1_CH0
    pin_function(PTE21, 3);  // 3: TPM1_CH1
    
    /* Set interrupt handler */
    NVIC_SetVector(TPM1_IRQn, (uint32_t)tpm1_isr);
    NVIC_EnableIRQ(TPM1_IRQn);
    
    /*Configure TPM1 in Interrupt Mode*/
    TPM_init_IC(TPM1, TPM_PLLFLL, TPM_MODULUS, TPM_CLK, PS_128);
    
    /* Configure Channel 0 from TPM1 as Input Capture for falling edge */
    TPM_CH_init(TPM1, 0, TPM_IC_RISING);       // rx pin rising (and 1PPS)
    TPM_CH_init(TPM1, 1, TPM_IC_RISING);       // tx pin falling
    
    TPM_CLK_MODE(TPM1, TPM_CLK);    // enable clock source to TPM1

    return 0;
}
