/*
Libreria principal:
en la misma se juntan las funciones de muestreo y toma de datos con las funciones de graficos
 para poder muestrear en display los datos analizados


*/

#include "mbed.h"
#include "math.h"
#include "st7920.h"
#include "ST7920Libreries.h"
#include "GraficadorDeBode.h"
#include "AD9833.h"
#include "math.h"
#include "string.h"
#include "hal.h"

#define Rango 100000

#define R 1000.0
#define C 1.0*pow(10.0,-6.0)

#define K pow(10.0,potencia)

enum {graficoComp, menuPrincipal, menuZoom, Info};
enum {graficocompleto, zoom};
enum {deshabilitado, habilitado};
enum {HDTexto, GraficoCompleto, Zoom, TomarMediciones, FaseAngulo, InfoAdicional};

//////////////////////////////////////////////////////////////
//////////// PUERTOS /////////////////////////////////////////
//////////////////////////////////////////////////////////////
Serial PC(USBTX,USBRX,115200);
DigitalIn PULSADORMENU(PTC17);
DigitalIn PULSADORRIGHT(PTA17);
DigitalIn PULSADORLEFT(PTD2);
DigitalIn PULSADORDOWN(PTA16);
DigitalIn PULSADORUP(PTD3);
DigitalIn FLANCOENTRADA(PTE20);
DigitalIn FLANCOSALIDA(PTE21);
AnalogIn ADC (PTC2);
AnalogIn ADC2 (PTC1);
DigitalOut A (PTB8);
DigitalOut B (PTB9);
//DigitalOut MC (PTB10);
DigitalOut HOLA(PTE29);
DigitalOut HOLA2(PTE30);
//////////////////////////////////////////////////////////////
//////////// VARIABLES ///////////////////////////////////////
//////////////////////////////////////////////////////////////
volatile char mode_rx_diff;    // flag
unsigned char hab=0;
unsigned int cantMediciones=114;
uint32_t diff;
unsigned char opcion=0;
unsigned char screen=0;
/*screen=3 menu 2
  screen=2 ZOOM
  screen=1 menu
  screen=0 grafico*/
unsigned char grafico_var=0;
/*grafico_var=0 grafico completo
  grafico_var=1 Zoom*/
unsigned char text_var=1;
/*texto habilitado/deshabilitado*/
unsigned char neg=0,pos=0,polpantalla[6]= {2,2,2,2,2,2};
unsigned char ZOOM=0;
float tiempo = 0;
unsigned char modo=fase;
unsigned char habgrafico=0;
unsigned char corte=0;
float  defasaje[108]= {0};
float defasaje_aux=0;
float gananciadB[108]= {0};
float ganancia[108] = {0};
float frecuencias[108]= {
    1,1,1,1,2,2,2,2,3,3,3,4,5,6,7,8,9,
    11,12,14,16,18,20,23,26,29,33,37,42,48,54,61,69,78,88,
    112,127,143,162,183,206,233,263,297,335,379,428,483,545,615,695,784,885,
    1128,1274,1483,1623,1832,2069,2335,2636,2975,3359,3792,4281,4832,5455,6158,6951,7847,8858,
    11288,12742,14384,16237,18329,20691,23357,26366,29763,33598,37926,42813,48329,54555,61584,69519,78476,88586,
    112883,127427,143844,162377,183298,206913,233572,263665,297635,335981,379269,428133,483293,545559,615848,695192,784759,885866
};
char fcVector[7]= {0};
float VMax=0;
unsigned char fc_var=0;
unsigned char fcVal=0;
unsigned char MULTIPLEXOR=4;
float muestras=0;
float var_aux_muestras=0;
float Vref=1/sqrt(2.0);
unsigned int k=0;
uint16_t var_fase=0;
unsigned char hab_tiempo=0;

//////////////////////////////////////////////////////////////
//////////// FUNCIONES ///////////////////////////////////////
//////////////////////////////////////////////////////////////

/*realiza un barrido en frecuencia y toma valores tanto de modulo como de fase
a su vez tambien varia la ganancia del modulo
*/
void barridoEnFrecuencia0a9(unsigned char i)
{
    unsigned int k=0;
    unsigned int j=0;
    setFreq(frecuencias[i]);
    wait(0.4);
    
    /*medicion de MODULO*/
    /*para frecuencias menores a 10Hz realiza un muestreo de 30000 muestras*/
    if(i<1) {
        MULTIPLEXOR=0;
        A=(MULTIPLEXOR) & 1;
        B=(MULTIPLEXOR & 2) >> 1;
        //MC=(MULTIPLEXOR & 4) >> 2;
        wait(0.5);
    }
    if(ganancia[i-1]>0.7) {
        if(MULTIPLEXOR>0)MULTIPLEXOR--;
        A=(MULTIPLEXOR) & 1;
        B=((MULTIPLEXOR) & 2) >> 1;
        //MC=((MULTIPLEXOR) & 4) >> 2;
        wait(0.5);
    } else if (ganancia[i-1]<0.075) {
        if(MULTIPLEXOR<2)MULTIPLEXOR++;
        A=(MULTIPLEXOR) & 1;
        B=((MULTIPLEXOR) & 2) >> 1;
        //MC=((MULTIPLEXOR) & 4) >> 2;
        wait(0.5);
    }
    if(MULTIPLEXOR == 0 )Vref=1/1.4;
    else if(MULTIPLEXOR == 1 )Vref=10/1.4;
    else if(MULTIPLEXOR == 2 )Vref=100/1.4;
    //else if(MULTIPLEXOR == 3 )Vref=0.1/sqrt(2.0);
    //else if(MULTIPLEXOR == 4 )Vref=0.01/sqrt(2.0);
    ganancia[i]=0;
    if(i>=18){
        /*for(unsigned int l=0; l<3; l++) {
            ganancia[i] += ADC.read();
        }
        ganancia[i]=ganancia[i]/3.0;*/
        ganancia[i] = ADC.read();
        }
    else if(i<18) {

        for(k=0; k<30000; k++) {
            var_aux_muestras=ADC2.read();
            if(var_aux_muestras > muestras)muestras = var_aux_muestras;
        }
        ganancia[i] = muestras;
    }
    muestras=0;
    k=0;
    gananciadB[i] = 20 * log10( 3.3 * ganancia[i] / (float)Vref);
    if(gananciadB[i]>60)gananciadB[i]=60;
    else if(gananciadB[i]<-60)gananciadB[i]=-60;
    if(gananciadB[i]<-19 && gananciadB[i]>-21)corte=i;
    
    /*medicion de FASE*/
    /*Realiza un promedio entre 3 valores de la misma frecuencia*/
    defasaje[i]=0;
    if(gananciadB[i]>-30) {
        //HOLA=1;

        new_tx_value=0;
        new_rx_value=0;

        while(1) {
            uint32_t diff;

            if (new_tx_value==1) {
                /*HOLA=1;
                HOLA=0;*/
                hab=2;

            }
            if(new_rx_value==1 && hab==2) {
                /*HOLA2=1;
                HOLA2=0;*/
                hab=1;

            }
            if(hab==1) {
                diff = rx_pin_captured_value - tx_pin_captured_value;
                if((diff / TICKS_PER_MS) < 1000000) {
                    defasaje[i]+=(diff/TICKS_PER_MS) * 360.0 / 1000.0 * frecuencias[i];
                    //printf("%.1fHz : %.2fº\n" ,frecuencias[i],defasaje[i] );
                }
                hab=0;
                j++;
                setFreq(frecuencias[i]);
                wait(0.3);
                if(j>=3)break;
                
            }
            
                new_tx_value=0;
                new_rx_value=0;
        }
    } else defasaje[i] = 1190; /*descarta cualquier valor de fase que corresponda a un valor de frecuencia cuya ganancia sea menor a -20dB*/
    if(defasaje[i]<1180)defasaje[i]=defasaje[i]/3.0;
    
    j=0;
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void grafico()
{
    /*grafica los ejes cartecianos con los valores de modulo y fase segun corresponda(Solo luego de tomar una primer medicion)*/
    Vline(0 , 10 , 64 , 1);
    Hline(0 , 32 , 127 , 1);
    DivisionesEjeY(2 , 10 , 6 , 10 , 3 , 1);
    DivisionesEjeX(10 , 19 , 6 , 32 , 3 , 1);
    if(text_var==1) {
        TextoEjeY(modo,0);
        TextoEjeX(0);
    }
    flechaY(2 , 32, 0 ,1);
    flechaY(125 , 32, 1 ,1);
    if(habgrafico==1) {
        graficarcompleto(gananciadB);
        if(modo==fase) {
            Vline(0,12+corte,63,1);
            for(unsigned int i = 0; i<32; i++) {
                point(12+18,i*2,0);  }      
        Vline(0,12+corte,63,1);
            for(unsigned int i = 0; i<32; i++) {
                point(12+18,i*2,0);
            }
        }
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void polaridad()
{
    /*Analiza si los valores de cierto rango de frecuencia estan por encima de 0, por debajo de 0 o ambos*/
    if(modo==modulo) {
        for(unsigned int j=0 ; j<6 ; j++) {
            for(unsigned int i=0 ; i <= (cantMediciones / 6) ; i++ ) {
                /*----------------------------------------------*/
                if(gananciadB[(j*(cantMediciones/6))+i]>=0)pos++;

                if(gananciadB[(j*(cantMediciones/6))+i]<0)neg++;
                /*----------------------------------------------*/
                if(pos>=(cantMediciones/6)-1) polpantalla[j]=0;

                else if(neg>=(cantMediciones/6)-1) polpantalla[j]=1;

                else polpantalla[j]=2;
            }
        }
    }
    if(modo==fase) {
        for(unsigned int j=0 ; j<6 ; j++) {
            for(unsigned int i=0 ; i <= (cantMediciones / 6) ; i++ ) {
                /*----------------------------------------------*/
                if(gananciadB[(j*(cantMediciones/6))+i]>=0)pos++;

                if(gananciadB[(j*(cantMediciones/6))+i]<0)neg++;
                /*----------------------------------------------*/
                if(pos>=(cantMediciones/6)-1) polpantalla[j]=0;

                else if(neg>=(cantMediciones/6)-1) polpantalla[j]=1;

                else polpantalla[j]=2;
            }
        }
    }
    neg=0;
    pos=0;

}

//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
/*Calcula la frecuencia de corte*/
void FrecuenciaDeCorte()
{
    unsigned long fc = 0;
    char InfoFc[9]= {'L','A',' ','F','C',' ','E','S',' '};
    for(fcVal=0 ; fcVal<cantMediciones; fcVal++) {
        if(gananciadB[fcVal] > VMax-4 && gananciadB[fcVal] < VMax-2) break;
    }
    fc = frecuencias[fcVal];
    fcVector[0] = fc / 100000 + 48;
    fcVector[1] = (fc / 10000) - ((fcVector[0] - 48) * 10) + 48;
    fcVector[2] = ((fc / 1000) - ((fcVector[1] - 48) * 10)) - ((fcVector[0] - 48) * 100) + 48;
    fcVector[3] = (((fc / 100) - ((fcVector[2] - 48) * 10)) - ((fcVector[1] - 48) * 100)) - ((fcVector[0] - 48) * 1000) + 48;
    fcVector[4] = ((((fc / 10) - ((fcVector[3] - 48) * 10)) - ((fcVector[2] - 48) * 100)) - ((fcVector[1] - 48) * 1000)) - ((fcVector[0] - 48) * 10000) + 48;
    fcVector[5] = (((((fc / 1) - ((fcVector[4] - 48) * 10)) - ((fcVector[3] - 48) * 100)) - ((fcVector[2] - 48) * 1000)) - ((fcVector[1] - 48) * 10000)) - ((fcVector[0] - 48) * 100000) + 48;
    //PC.printf("%d%d%d%d%d%dHz",fcVector[0],(fcVector[1]),fcVector[2],fcVector[3],fcVector[4],fcVector[5]);
    strcat(InfoFc,fcVector);
    //PC.puts(InfoFc);
    text(7,7,InfoFc,16,1);
    fc_var=1;
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void infoBasica()
{

    FrecuenciaDeCorte();


    //PC.printf("%d%d%d%d%d%dHz",fcVector[0],fcVector[1],fcVector[2],fcVector[3],fcVector[4],fcVector[5]);
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
float Valormaximo ()
{
    float aux = -100;
    for(unsigned int i=0 ; i<cantMediciones ; i++ ) {
        if(gananciadB[i]>aux) {
            aux = gananciadB[i];
        }
    }
    return aux;
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void graficoZOOM()
{
    /*-------------------------------------*//*ZOOM 0: GANANCIA POSITIVA*//*-------------------------------------*/
    Vline(0 , 1 , 63 , 1);
    if(polpantalla[ZOOM-1]==0) {
        Hline(0 , 62 , 127 , 1);
        DivisionesEjeY(2 , 20 , 3 , 1 , 3 , 1);
        DivisionesEjeX(1 , 125 , 1 , 62 , 3 , 1);
        if(text_var==1) {
            text(4 , 62 , "0" , 1, 1);
            text(4 , 4 , "60" , 2 , 1);
            text(4 , 24 , "40" , 2 , 1);
            text(4 , 44 , "20" , 2 , 1);
            text(13,4,"dB",2,1);//dB
        }
        if(ZOOM==1) {
            text(104,4,"1-10HZ",6,1);
        }
        if(ZOOM==2) {
            text(96,4,"10-100HZ",8,1);
        }
        if(ZOOM==3) {
            text(96,4,"100-1KHZ",8,1);
        }
        if(ZOOM==4) {
            text(96,4,"1K-10KHZ",8,1);
        }
        if(ZOOM==5) {
            text(88,4,"10K-100KHZ",10,1);
        }
        if(ZOOM==6) {
            text(92,4,"100K-1MHZ",9,1);
        }

    }
    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
    /*-------------------------------------*//*ZOOM 1: GANANCIA NEGATIVA*//*-------------------------------------*/
    if(polpantalla[ZOOM-1]==1) {
        Hline(0 , 1 , 127 , 1);
        DivisionesEjeY(1 , 20 , 3 , 1 , 3 , 1);
        DivisionesEjeX(1 , 125 , 1 , 1 , 3 , 1);
        if(text_var==1) {
            text(4 , 6 , "0" , 1, 1);
            text(4 , 23 , "-20" , 3, 1);
            text(4 , 43 , "-40" , 3 , 1);
            text(4 , 63 , "-60" , 3 , 1);
            text(17,63,"dB",2,1);//dB
        }
        if(ZOOM==1) {
            text(104,63,"1-10HZ",6,1);
        }
        if(ZOOM==2) {
            text(96,63,"10-100HZ",8,1);
        }
        if(ZOOM==3) {
            text(96,63,"100-1KHZ",8,1);
        }
        if(ZOOM==4) {
            text(96,63,"1K-10KHZ",8,1);
        }
        if(ZOOM==5) {
            text(96,63,"10K-100KHZ",10,1);
        }
        if(ZOOM==6) {
            text(92,63,"100K-1MHZ",9,1);
        }

    }
    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
    /*-------------------------------------*//*ZOOM 2: GANANCIA MIXTA*//*-------------------------------------*/
    if(polpantalla[ZOOM-1]==2) {
        Hline(0 , 32 , 127 , 1);
        DivisionesEjeY(2 , 10 , 6 , 1 , 3 , 1);
        DivisionesEjeX(1 , 125 , 1 , 32 , 3 , 1);
        if(text_var==1) {
            text(4,4,"60",2,1);//60
            text(4,14,"40",2,1);//40
            text(4,24,"20",2,1);//20
            text(6,38,"0",1,1);//0
            text(3,44,"-20",3,1);//-20
            text(3,54,"-40",3,1);//-40
            text(3,63,"-60",3,1);//-60
            text(13,4,"dB",2,1);//dB
        }
        if(ZOOM==1) {
            text(104,4,"1-10HZ",6,1);
        }
        if(ZOOM==2) {
            text(96,4,"10-100HZ",8,1);
        }
        if(ZOOM==3) {
            text(96,4,"100-1KHZ",8,1);
        }
        if(ZOOM==4) {
            text(96,4,"1K-10KHZ",8,1);
        }
        if(ZOOM==5) {
            text(96,4,"10K-100KHZ",10,1);
        }
        if(ZOOM==6) {
            text(92,4,"100K-1MHZ",9,1);
        }

    }
    if(habgrafico==1) {
        graficarZOOM(gananciadB);
    }
    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void menu()
{
    Cuadrado(0,127,8,63,1);
    text(57,6,"MENU",4,1);
    text(7,14,"HABILITAR O DESHABILITAR TEXTO",30,1);
    text(7,23,"GRAFICO COMPLETO",16,1);
    text(7,32,"ZOOM",4,1);
    text(7,41,"TOMAR MEDICIONES Y GRAFICAR",26,1);
    text(7,50,"MOSTRAR MODULO O FASE",21,1);
    text(7,59,"INFORMACION ADICIONAL",21,1);
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void menu2()
{
    Cuadrado(0,127,8,63,1);
    text(57,6,"ZOOM",4,1);
    text(7,14,"1HZ A 10HZ",10,1);
    text(7,23,"10HZ A 100HZ",12,1);
    text(7,32,"100HZ A 1KHZ",12,1);
    text(7,41,"1KHZ A 10KHZ",12,1);
    text(7,50,"10KHZ A 100KHZ",14,1);
    text(7,59,"100KHZ A 1MHZ",13,1);
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void graficarcompleto(float gananciadB[])
{
    /*grafica los valores tomados previamente*/
    if(modo==modulo) {
        for(unsigned int i=1 ; i<=cantMediciones ; i++) {
            if(gananciadB[i]>=-60 && gananciadB[i]<=60)point(10+i,32 - (gananciadB[i]/2.0),0);
            wait_ms(10);
            //linea(10+((114/cantMediciones)*(i-1)) , 32 - (gananciadB[i-1]/2.0) , 10+((114/cantMediciones)*i) , 32 - (gananciadB[i]/2.0), 1);
            //32 - ((20.0 * log10(hola))/2.0)
        }
    } else if(modo==fase) {
        for(unsigned int i=1 ; i<=cantMediciones ; i++) {
            if(defasaje[i]<=180)point(10+i,32 + (defasaje[i]/6.0),0);
            else if(defasaje[i]>180 && defasaje[i]<360)point(10+i,32 - ((360 - defasaje[i])/6.0),0);
            else
                wait_ms(10);
        }
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void graficarZOOM(float gananciadB[])
{
    polaridad();
    if(modo==modulo) {
        if(polpantalla[ZOOM-1]==0) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 62 - gananciadB[(cantMediciones/6)*(ZOOM-1)+(i-1)] , 1+(i*126/(cantMediciones/6)) , 62-gananciadB[(cantMediciones/6)*(ZOOM-1)+(i)], 1);
            }
        }
        if(polpantalla[ZOOM-1]==1) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 2 - gananciadB[(cantMediciones/6)*(ZOOM-1)+(i-1)] , 1+(i*126/(cantMediciones/6)) , 2-gananciadB[(cantMediciones/6)*(ZOOM-1)+(i)], 1);
            }
        }
        if(polpantalla[ZOOM-1]==2) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 32 - (gananciadB[(cantMediciones/6)*(ZOOM-1)+(i-1)]/2) , 1+(i*126/(cantMediciones/6)) , 32-(gananciadB[(cantMediciones/6)*(ZOOM-1)+(i)]/2), 1);
            }
        }
    } else if(modo==fase) {
        if(polpantalla[ZOOM-1]==0) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 62 - defasaje[(cantMediciones/6)*(ZOOM-1)+(i-1)/3] , 1+(i*126/(cantMediciones/6)) , 62-defasaje[(cantMediciones/6)*(ZOOM-1)+(i)/3], 1);
            }
        }
        if(polpantalla[ZOOM-1]==1) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 2 - defasaje[(cantMediciones/6)*(ZOOM-1)+(i-1)/3] , 1+(i*126/(cantMediciones/6)) , 2-defasaje[(cantMediciones/6)*(ZOOM-1)+(i)/3], 1);
            }
        }
        if(polpantalla[ZOOM-1]==2) {
            for(unsigned int i=1 ; i<=(cantMediciones/6) ; i++) {
                linea(1+((i-1)*126/(cantMediciones/6)) , 32 - (defasaje[(cantMediciones/6)*(ZOOM-1)+(i-1)]/6) , 1+(i*126/(cantMediciones/6)) , 32-(defasaje[(cantMediciones/6)*(ZOOM-1)+(i)]/6), 1);
            }
        }
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void PULSADORMENU_fun ()
{
    //enum{grafico, menu, ZOOM, menu2};
    switch(screen) {
        case graficoComp:
            if(PULSADORMENU==1) {
                wait(0.1);
                if(PULSADORMENU==1)
                    CLRScreen();
                menu();
                PC.printf("menu");
                screen=1;
            }
            break;
        case menuPrincipal:
            if(PULSADORMENU==1) {
                wait(0.1);
                if(PULSADORMENU==1)
                    CLRScreen();
                /*-------------------------------------*//*OPCION 0: HABILITACION DE TEXTO*//*-------------------------------------*/
                if(opcion==HDTexto) {
                    text_var = !text_var;
                    grafico();
                    screen = 0;
                } else if(opcion==GraficoCompleto) {
                    grafico();
                    ZOOM = 0;
                    grafico_var=0;
                    screen = 0;
                    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
                    /*-------------------------------------*//*OPCION 2: ZOOM*//*------------------------------------------------------*/
                } else if(opcion==Zoom) {
                    menu2();
                    screen = 2;
                    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
                    /*-------------------------------------*//*OPCION 3: TOMA DE VALORES*//*-------------------------------------*/
                } else if(opcion==TomarMediciones) {
                    if(Rango==100000)cantMediciones=90;
                    else if(Rango==1000000)cantMediciones=108;
                    text(31,15,"TOMANDO VALORES",15,1);
                    point(92,15,1);
                    point(94,15,1);
                    point(96,15,1);
                    Cuadrado(5,121,20,50,1);
                    setFreq(1);
                    wait(0.3);
                    for(unsigned int i= 0 ; i<cantMediciones  ; i++ ) {
                        barridoEnFrecuencia0a9(i);
                        Vline(20,6+i,50,1);
                    }
                    setFreq(1000);
                    /*-------------------------------------*//*-------------------------------------*//*-------------------------------------*/
                    CLRScreen();
                    habgrafico=1;
                    ZOOM=0;
                    fc_var=0;
                    grafico();
                    polaridad();
                    VMax=Valormaximo();
                    screen = 0;
                } else if(opcion==FaseAngulo) {
                    //CLRScreen();
                    if(modo==modulo)modo = fase;
                    else if(modo==fase)modo = modulo;
                    grafico();
                    ZOOM = 0;
                    grafico_var=0;
                    screen = 0;
                } else if(opcion==InfoAdicional) {
                    //CLRScreen();
                    infoBasica();
                    screen=3;
                }
                opcion = 0;
            }
            break;
        case menuZoom:
            if(PULSADORMENU==1) {
                wait(0.1);
                if(PULSADORMENU==1)
                    CLRScreen();
                ZOOM = opcion + 1;
                graficoZOOM();
                grafico_var=1;
                screen=0;
                opcion = 0;
            }
            break;
        case Info:
            if(PULSADORMENU==1) {
                wait(0.1);
                if(PULSADORMENU==1)
                    CLRScreen();
                grafico();
                screen=0;
            }
            break;
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
unsigned char PULSADORDOWN_fun()
{
    if(PULSADORDOWN==1 && (screen == 1 || screen == 2)) {
        wait(0.1);
        if(PULSADORDOWN==1) {
            if(opcion<5 && screen == 1)opcion++;
            else if(opcion<5 && screen == 2)opcion++;
            for(unsigned char x=1 ; x < 5 ; x++) {
                CLRVline(9,x,62);
            }
        }
    }
    return opcion;
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
unsigned char PULSADORUP_fun()
{
    if(PULSADORUP==1 && (screen == 1 || screen == 2)) {
        wait(0.1);
        if(PULSADORUP==1) {
            if(opcion>0)opcion--;
            for(unsigned char x=1 ; x < 5 ; x++) {
                CLRVline(9,x,62);
            }
        }
    }
    return opcion;
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void PULSADORLEFT_fun()
{
    char var=0;
    if(PULSADORLEFT==1) {
        wait(0.1);
        if(PULSADORLEFT==1 && screen ==0) {
            if(ZOOM == 0)
                var=1;
            else var=0;
            if(ZOOM >= 1) {
                CLRScreen();
                ZOOM--;
            }
            if (ZOOM == 0) {
                if(var==0)CLRScreen;
                grafico();
            }
        }
        if(grafico_var==1 && ZOOM >= 1) {
            graficoZOOM();
            if(habgrafico==1) {
                graficarZOOM(gananciadB);
            }
        }
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
void PULSADORRIGHT_fun()
{
    if(PULSADORRIGHT==1 && screen ==0) {
        wait(0.1);
        if(PULSADORRIGHT==1) {
            if(ZOOM < 6) {
                if(ZOOM==0)grafico_var=1;
                CLRScreen();
                ZOOM++;
                if(grafico_var==1) graficoZOOM();
                if(habgrafico==1) {
                    graficarZOOM(gananciadB);
                }
            }
        }
    }
}
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////
unsigned char screen_pass()
{
    return screen;
}

void MedidorDeTiempo()
{
    if(hab_tiempo)
        tiempo++;
}