/*
    Programmer: Roger McArdell
    Date: 01/08/2017
    Version 
    V0.1    First version

*/
#include <string>
#include "mbed.h"
#include "Pins.h"
#include "Matrix.h"
#include "BoardComms.h"
#include "Timers.h"


// Prototypes
void CEC0InteruptRoutine();
void CEC1InteruptRoutine();
void CEC2InteruptRoutine();
void CEC3InteruptRoutine();
void HDBaseTInterruptRoutine();
void CheckButtons();
void Button1Down(); 
void Button2Down();
void Button3Down();
void Button4Down();
void Setup();

DigitalOut CECReset0(P0_12, 1);

int main() 
{
    Setup();
    
    printf("Program Started\r\n");
    while(1) 
    {
        TimeLoop();
        if (pc.readable())
            CheckForData();
        if (CEC0INTFlag || CEC1INTFlag || CEC2INTFlag || CEC3INTFlag)
            CheckButtons();
        if (aboxPort.readable())
            CheckaboxData(); 
    }
}
void Setup()
{
    CECBoot0 = 1;
    CECBoot1 = 1;
    CECBoot2 = 1;
    CECBoot3 = 1;
    //CECReset0 = 1;
    CECReset1 = 1;
    CECReset2 = 1;
    CECReset3 = 1;
    aboxPort.baud(9600);
    AUXPort.baud(9600);
    TimeLoopSetup();
    // Attach Interrupts
    HDBaseTINT.rise(&HDBaseTInterruptRoutine);
    CECINT0.rise(&CEC0InteruptRoutine);
    CECINT1.rise(&CEC1InteruptRoutine);
    CECINT2.rise(&CEC2InteruptRoutine);
    CECINT3.rise(&CEC3InteruptRoutine);
}

void CEC0InteruptRoutine() {CEC0INTFlag = 1;}
void CEC1InteruptRoutine() {CEC1INTFlag = 1;}
void CEC2InteruptRoutine() {CEC2INTFlag = 1;}
void CEC3InteruptRoutine() {CEC3INTFlag = 1;}
void HDBaseTInterruptRoutine()
{
    
}
void CheckButtons()
{
    if (CEC0INTFlag)
    {
        CEC0INTFlag = 0;
        Button1Down();   
    }   
    if (CEC1INTFlag)
    {
        CEC1INTFlag = 0;
        Button2Down();   
    }  
    if (CEC2INTFlag)
    {
        CEC2INTFlag = 0;
        Button3Down();   
    }  
    if (CEC3INTFlag)
    {
        CEC3INTFlag = 0;
        Button4Down();   
    }  
}
void Button1Down()
{
    aboxPort.printf("BUT 011\n");   
}
void Button2Down()
{
    aboxPort.printf("BUT 021\n");
}
void Button3Down()
{
    aboxPort.printf("BUT 031\n");
}
void Button4Down()
{
    aboxPort.printf("BUT 041\n");
}


