/*
    Programmer: Roger McArdell
    Date: 02/08/2017
    Version 
    V0.1    First version
*/

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Timer T1;
Timer T2;
Timer T3;

// Function Prototypes
void TimeLoopaBox();
void TimeLoopShort();
void TimeLoopLong();
void TimeLoopSetup();
void CheckSyncs ();
void SwitchOff();

void TimeLoopSetup()
{
    T1.start();
    T2.start();
    T3.start(); 
}

void TimeLoop()
{
    if (T1.read_ms() >= 1000) //10
    {
        T1.reset();
        TimeLoopaBox();    
    }
    if (T2.read_ms() >= 100) //100
    {
        T2.reset();
        TimeLoopShort();
    }
    if (T3.read_ms() >= 750)
    {
        T3.reset();  
        TimeLoopLong(); 
    }   
}
void TimeLoopaBox()
{
    //led1 = !led1;  
    
}
void TimeLoopShort()
{
    //led2 = !led2; 
    char Result = GetConnectedStatus();
    
    if (Result && '\x01') //XXX1
    {
        if (!HDMI1Sync)
        {
            HDMI1Sync = 1;
            aboxPort.printf("DSY%d11\n", IDNumber);
            pc.printf("HDMI 1 On\r\n");
            if (SystemState == IsOff)
            {
                WriteCEC(Button1Address, Green);
                SwitchMatrix(HDMI1, HDMI1); 
                SystemState = IsHDMI1;
            }
            else
                WriteCEC(Button1Address, Blue);   
        }
    }
    else
    {
        if (HDMI1Sync)
        {
            HDMI1Sync = 0;
            aboxPort.printf("DSY%d10\n", IDNumber);
            pc.printf("HDMI 1 Off\r\n");
            WriteCEC(Button1Address, Off);
            if (SystemState == IsHDMI1) 
                CheckSyncs();  //Check for another sync               
        }       
    }
    if (Result && '\x02')
    {
        if (!HDMI2Sync)
        {
            HDMI2Sync = 1;
            aboxPort.printf("DSY%d21\n", IDNumber);
            pc.printf("HDMI 2 On\r\n");
            if (SystemState == IsOff)
            {
                WriteCEC(Button2Address, Green);
                SwitchMatrix(HDMI2, HDMI2); 
                SystemState = IsHDMI2;
            }
            else
                WriteCEC(Button2Address, Blue); 
        }
    }
    else
    {
        if (HDMI2Sync)
        {
            HDMI2Sync = 0;
            aboxPort.printf("DSY%d20\n", IDNumber);
            pc.printf("HDMI 2 Off\r\n");
            WriteCEC(Button2Address, Off);
            if (SystemState == IsHDMI2) 
                CheckSyncs();  //Check for another sync  
        }
        
    }         
    if (Result && '\x04')
    {
        if (!HDMI3Sync)
        {
            HDMI3Sync = 1;
            aboxPort.printf("DSY%d31\n", IDNumber);
            pc.printf("HDMI 3 On\r\n");
            if (SystemState == IsOff)
            {
                WriteCEC(Button3Address, Green);
                SwitchMatrix(HDMI3, HDMI3); 
                SystemState = IsHDMI3;
            }
            else
                WriteCEC(Button3Address, Blue);   
        }
    }
    else
    {
        if (HDMI3Sync)
        {
            HDMI3Sync = 0;
            aboxPort.printf("DSY%d30\n", IDNumber);
            pc.printf("HDMI 3 Off\r\n");
            WriteCEC(Button3Address, Off);
            if (SystemState == IsHDMI3) 
                CheckSyncs();  //Check for another sync               
        }       
    }
    if (Result && '\x08')
    {
        if (!HDMI4Sync)
        {
            HDMI4Sync = 1;
            aboxPort.printf("DSY%d41\n", IDNumber);
            pc.printf("HDMI 4 On\r\n");
            if (SystemState == IsOff)
            {
                WriteCEC(Button4Address, Green);
                SwitchMatrix(HDMI4, HDMI4); 
                SystemState = IsHDMI4;
            }
            else
                WriteCEC(Button4Address, Blue);   
        }
    }
    else
    {
        if (HDMI4Sync)
        {
            HDMI4Sync = 0;
            aboxPort.printf("DSY%d40\n", IDNumber);
            pc.printf("HDMI 4 Off\r\n");
            WriteCEC(Button4Address, Off);
            if (SystemState == IsHDMI4) 
                CheckSyncs();  //Check for another sync               
        }       
    }    
}
void TimeLoopLong()
{
    //led3 = !led3;        
}
void CheckSyncs ()
{
    //Check for another sync
    if (HDMI1Sync)
    {
        WriteCEC(Button1Address, Green);
        SwitchMatrix(HDMI1, HDMI1); 
        SystemState = IsHDMI1;
        if (HDMI2Sync)
            WriteCEC(Button2Address, Blue);  
        if (HDMI3Sync)
            WriteCEC(Button3Address, Blue); 
        if (HDMI4Sync)
            WriteCEC(Button4Address, Blue);
    }    
    else if (HDMI2Sync)
    {
        WriteCEC(Button2Address, Green);
        SwitchMatrix(HDMI2, HDMI2); 
        SystemState = IsHDMI2;
        if (HDMI1Sync)
            WriteCEC(Button1Address, Blue);  
        if (HDMI3Sync)
            WriteCEC(Button3Address, Blue); 
        if (HDMI4Sync)
            WriteCEC(Button4Address, Blue);
        
    }
    else if (HDMI3Sync)
    {
        WriteCEC(Button3Address, Green);
        SwitchMatrix(HDMI3, HDMI3); 
        SystemState = IsHDMI3;
        if (HDMI1Sync)
            WriteCEC(Button1Address, Blue); 
        if (HDMI2Sync)
            WriteCEC(Button2Address, Blue);   
        if (HDMI4Sync)
            WriteCEC(Button4Address, Blue);
    }
    else if (HDMI4Sync)
    {
        WriteCEC(Button4Address, Green);
        SwitchMatrix(HDMI4, HDMI4); 
        SystemState = IsHDMI4;
        if (HDMI1Sync)
            WriteCEC(Button1Address, Blue); 
        if (HDMI2Sync)
            WriteCEC(Button2Address, Blue);  
        if (HDMI3Sync)
            WriteCEC(Button3Address, Blue); 
    }   
    else if (ExternalSync)
    {
        aboxPort.printf("MAT%d00\n", IDNumber);
    }
    else SwitchOff();
}
void SwitchOff()
{
    SystemState = IsOff;
    aboxPort.printf("MAT%d00\n", IDNumber);
}
