/*
    Programmer: Roger McArdell
    Date: 02/08/2017
    Version 
    V0.1    First version
*/

#define Off 0
#define Green 0x04
#define Blue 0x08
#define Red 0x0C
#define FlashRed 0x10
#define FlashRedGreen 0x14
#define FlashGreen 0x18 //00011000
#define FlashBlue 0x1C // 00011100

#define Button1Address 0x80  //0x80
#define Button2Address 0x82  //0x82
#define Button3Address 0x84  //0x84
#define Button4Address 0x86  //0x86

#define IsOff 0
#define Laptop1 1
#define Laptop2 2
#define Laptop3 3
#define Laptop4 4

#define IsOff 0
#define IsHDMI1 1
#define IsHDMI2 2
#define IsHDMI3 3
#define IsHDMI4 4
#define IsNextBox 5
#define IsVCIdle 6
#define IsVCInCall 7
#define IsAux1 8
#define IsAux2 9
#define IsAux3 10

#define HDMI1 1
#define HDMI2 2
#define HDMI3 3
#define HDMI4 4

uint8_t SystemState = 0;
uint8_t IDNumber = 1;

bool CEC0INTFlag = 0;
bool CEC1INTFlag = 0;
bool CEC2INTFlag = 0;
bool CEC3INTFlag = 0;

// UARTS
Serial aboxPort(P0_14,P0_13); //TX, RX
Serial AUXPort(P0_19,P0_18);
Serial pc(USBTX, USBRX);

//Digital Ins
DigitalIn PSEStatus(P2_2);

//Interrupts
InterruptIn HDBaseTINT(P0_6);
InterruptIn CECINT0(P0_20);
InterruptIn CECINT1(P0_21);
InterruptIn CECINT2(P0_22);
InterruptIn CECINT3(P0_23);

//Digital Outs
DigitalOut AuxPortDIR(P2_7);
DigitalOut HDMIRST(P0_8);
DigitalOut HDBaseTUSBID(P2_5);
DigitalOut CECBoot0(P0_11);
DigitalOut CECBoot1(P0_16);
DigitalOut CECBoot2(P1_13);
DigitalOut CECBoot3(P1_21);
//DigitalOut CECReset0(P0_12);
DigitalOut CECReset1(P0_17);
DigitalOut CECReset2(P1_20);
DigitalOut CECReset3(P1_23);

//I2C
I2C I2CHDMI(P1_24,P0_7); //SDA, SCL 
I2C I2CBus(P0_5,P0_4);

