/*
    Programmer: Roger McArdell
    Date: 03/08/2017
    Version 
    V0.1    First version
*/

static uint8_t MatrixAddWrite = '\x88';
static uint8_t MatrixAddRead = '\x89';

// Prototypes
void SwitchMatrix(uint8_t PortA, uint8_t PortB);
void ReadMatrix(char Add,int Bytes);
void WriteMatrix(string Contents);
char GetConnectedStatus();

bool HDMI1Sync = 0;
bool HDMI2Sync = 0;
bool HDMI3Sync = 0;
bool HDMI4Sync = 0;
bool ExternalSync = 0;

void SwitchMatrix(uint8_t PortA, uint8_t PortB)
{
    //Split mode; Reg 02,byte 0 bit 3 = 1; TXA and TXB are the same 
    //Mux mode;   Reg 02,byte 0 bit 3 = 0; TXA and TXB are individually selected, but must not be the same (default)
    uint8_t TempA;
    uint8_t TempB;
    char data[2];
    
    printf("Switch Matrix, PortA: %d, PortB: %dr\n", PortA, PortB);
    aboxPort.printf("MAT%d%d\n", IDNumber, PortA);
    
    TempA = PortA - 49;
    
    switch(PortB)
    {
        case'1': TempB = 0; // 0000 
        case'2': TempB = 4; // 0100
        case'3': TempB = 8; // 1000
        case'4': TempB = 12;// 1100
    }
    
    if (PortA == PortB)
    {       
        WriteMatrix("MR0288\x0D"); // select Split mode: Reg02, 10001000 \x88
        
        switch(PortA)
        {
            case'1': WriteMatrix("MR0700\x0D"); break;
            case'2': WriteMatrix("MR0701\x0D"); break;
            case'3': WriteMatrix("MR0702\x0D"); break;
            case'4': WriteMatrix("MR0703\x0D"); break;
        }
    }
    else
    { 
        WriteMatrix("MR0280\x0D"); // Select Mux mode: Reg02, 1000000 \x80
        
        data[0] = '\x07';
        data[1] = TempA + TempB;;
        
        printf("Register: %d", data[0]);
        printf(" With data: %d ",data[1]);
        printf(" (numbers in decimal)\r\n");
         
        I2CHDMI.start(); // Not sure if this is required.
        I2CHDMI.write(MatrixAddWrite, data, 2);   
        I2CHDMI.stop();    
    }   
}
void ReadMatrix(char SlaveAdd,int Bytes)
{
    char TempRead[Bytes]; 
    I2CHDMI.start(); // Not sure if this is required.
    I2CHDMI.write(MatrixAddWrite, &SlaveAdd, 1, true); //  "repeated-START condition" required, set by the true statement
    I2CHDMI.read(MatrixAddRead, TempRead, Bytes);
    I2CHDMI.stop();
    
    pc.printf("Register %d: \r\n",SlaveAdd);
    for (uint8_t I = 0; I < Bytes; I++)
    {
        pc.printf("Value is %d: \r\n",TempRead[I]);
    }   
}

void WriteMatrix(string Contents)
{
    char data[10];
    uint8_t NoOfBytes = 0;
    
    //printf("1 Length: %d Contents: %s\r\n", Contents.length(), Contents.c_str());
    //printf("\r\n");   
    
    uint8_t I = 0;
    uint8_t J = 0;
    bool Even = 1;
    while (Contents[I] != '\x0D')
    {
        if (Even)
        {
            //printf("Even I=%d, Byte = %d ", I, Contents[I+2]);
            if (Contents[I+2] >= 48 && Contents[I+2] <= 57)
                data[J] = (Contents[I+2] - 48)*16; // move to the most significate nibble
            else if (Contents[I+2] >= 65 && Contents[I+2] <= 70)
                data[J] = (Contents[I+2] - 55)*16;
            else if (Contents[I+2] >= 97 && Contents[I+2] <= 102)
                data[J] = (Contents[I+2] - 87)*16;
            Even = 0;    
            //printf("data[J] = %d, J = %d\r\n", data[J], J);      
        }
        else
        { 
            //printf("Odd I=%d, Byte = %d ", I, Contents[I+2]);
            if (Contents[I+2] >= 48 && Contents[I+2] <= 57)
                data[J] = data[J] + (Contents[I+2] - 48);
            else if (Contents[I+2] >= 65 && Contents[I+2] <= 70)
                data[J] = data[J] + (Contents[I+2] - 55);
            else if (Contents[I+2] >= 97 && Contents[I+2] <= 102)
                data[J] = data[J] + (Contents[I+2] - 87); 
            //printf("data[J] = %d, J = %d\r\n", data[J], J);   
                
            NoOfBytes = J;
            J++;    
            Even = 1; 
        }  
        I++;           
    }     
    pc.printf("Register: %d", data[0]);
    pc.printf(" With data:");
    for (I = 1; I < NoOfBytes; I++)
    {
        printf(" %d ",data[I]);
    }
    pc.printf(" (numbers in decimal)\r\n");
     
    I2CHDMI.start(); // Not sure if this is required.
    I2CHDMI.write(MatrixAddWrite, data, NoOfBytes);   
    I2CHDMI.stop();  
}
char GetConnectedStatus()
{
    char TempRead[3]; 
    char SlaveAdd = '\x07';
    I2CHDMI.start(); // Not sure if this is required.
    I2CHDMI.write(MatrixAddWrite, &SlaveAdd, 1, true); //  "repeated-START condition" required, set by the true statement
    I2CHDMI.read(MatrixAddRead, TempRead, 3);
    I2CHDMI.stop();
    
    return TempRead[2];
}
    
    
    

