/*
    Programmer: Roger McArdell
    Date: 02/08/2017
    Version 
    V0.1    First version
*/
const string Revision = "0.0.1";

static uint8_t EthAddWrite = '\xBE';
static uint8_t EthAddRead = '\xBF';

// Prototypes
void CheckForData();
void CheckaboxData();
void WriteCEC(char Port, char data);
void ReadCEC();
void Processabox(string InString);
void SetLEDs(uint8_t LEDNo, uint8_t LEDState);

string RegBuff;
string InString1 = "";

void CheckForData()
{ 
    string bufchar;
    
    char c;
    while(pc.readable())
    {
        c = pc.getc();
        RegBuff += c;  
        bufchar = c;
        pc.printf("%s", bufchar.c_str()); // echo back to screen
         
        if (c == '\x0D') 
        {
            switch(RegBuff[0])
            {
                case 'M': // Matrix
                    if (RegBuff[1] == 'R') //Read
                    {
                        pc.printf("Byte Received Read: %s\r\n", RegBuff.c_str());
                        switch(RegBuff[2])
                        {
                            case '0':
                                switch(RegBuff[3])
                                {
                                    case '0': ReadMatrix('\x00',1);  break;
                                    case '1': ReadMatrix('\x01',1);  break;
                                    case '2': ReadMatrix('\x02',1);  break;
                                    case '3': ReadMatrix('\x03',4);  break;   
                                    case '4': ReadMatrix('\x04',8);  break; 
                                    case '5': ReadMatrix('\x05',2);  break;
                                    case '6': ReadMatrix('\x06',2);  break;
                                    case '7': ReadMatrix('\x07',1);  break;
                                    case '8': ReadMatrix('\x08',1);  break;
                                    case '9': ReadMatrix('\x09',1);  break;
                                    case 'A': ReadMatrix('\x0A',1);  break;
                                    case 'B': ReadMatrix('\x0B',2);  break;
                                    case 'C': ReadMatrix('\x0C',1);  break;
                                    case 'E': ReadMatrix('\x0E',6);  break;
                                    case 'F': ReadMatrix('\x0F',6);  break;
                                }
                            break;
                            case '1':
                                switch(RegBuff[3])
                                {
                                    case '0': ReadMatrix('\x10',5);  break;
                                    case '1': ReadMatrix('\x11',5);  break;
                                    case '2': ReadMatrix('\x12',5);  break;
                                    case '3': ReadMatrix('\x13',5);  break;   
                                    case '4': ReadMatrix('\x14',5);  break; 
                                    case '5': ReadMatrix('\x15',5);  break;
                                    case '6': ReadMatrix('\x16',5);  break;
                                    case '7': ReadMatrix('\x17',5);  break;
                                    case '8': ReadMatrix('\x18',5);  break;
                                }
                            break;
                            case '2':
                                switch(RegBuff[3])
                                {
                                    case '0': ReadMatrix('\x20',5);  break;
                                    case '1': ReadMatrix('\x21',5);  break;
                                }
                            break;   
                        } 
                    }
                    else if (RegBuff[1] == 'W') //Write
                    {
                        pc.printf("Byte Received Write: %s\r\n", RegBuff.c_str());
                        WriteMatrix(RegBuff);        
                    }
                    else if (RegBuff[1] == 'S') // Set matrix switcher
                    {
                       SwitchMatrix(RegBuff[2], RegBuff[3]); 
                    }
                break;       
                case 'S':
                    if (RegBuff[1] == 'R') //Read
                    {
                    }
                    else
                    if (RegBuff[1] == 'W') //Write
                    {
                        switch(RegBuff[2])
                        {
                            case '1':
                                switch(RegBuff[3])
                                {
                                    case '0': WriteCEC(Button1Address, Off); break;
                                    case '1': WriteCEC(Button1Address, Green); break;
                                    case '2': WriteCEC(Button1Address, Blue); break;
                                    case '3': WriteCEC(Button1Address, Red); break;
                                    case '4': WriteCEC(Button1Address, FlashRed); break;
                                    case '5': WriteCEC(Button1Address, FlashRedGreen); break;
                                    case '6': WriteCEC(Button1Address, FlashBlue); break;
                                }
                            break;                            
                            case '2':
                                switch(RegBuff[3])
                                {
                                    case '0': WriteCEC(Button2Address, Off); break;
                                    case '1': WriteCEC(Button2Address, Green); break;
                                    case '2': WriteCEC(Button2Address, Blue); break;
                                    case '3': WriteCEC(Button2Address, Red); break;
                                    case '4': WriteCEC(Button2Address, FlashRed); break;
                                    case '5': WriteCEC(Button2Address, FlashRedGreen); break;
                                    case '6': WriteCEC(Button2Address, FlashBlue); break;
                                }
                            break;
                            case '3':
                                switch(RegBuff[3])
                                {
                                    case '0': WriteCEC(Button3Address, Off); break;
                                    case '1': WriteCEC(Button3Address, Green); break;
                                    case '2': WriteCEC(Button3Address, Blue); break;
                                    case '3': WriteCEC(Button3Address, Red); break;
                                    case '4': WriteCEC(Button3Address, FlashRed); break;
                                    case '5': WriteCEC(Button3Address, FlashRedGreen); break;
                                    case '6': WriteCEC(Button3Address, FlashBlue); break;
                                }
                            break;
                            case '4':
                                switch(RegBuff[3])
                                {
                                    case '0': WriteCEC(Button4Address, Off); break;
                                    case '1': WriteCEC(Button4Address, Green); break;
                                    case '2': WriteCEC(Button4Address, Blue); break;
                                    case '3': WriteCEC(Button4Address, Red); break;
                                    case '4': WriteCEC(Button4Address, FlashRed); break;
                                    case '5': WriteCEC(Button4Address, FlashRedGreen); break;
                                    case '6': WriteCEC(Button4Address, FlashBlue); break;
                                }
                            break;
                        }
                    }
                break;
                case 'L':
                    Processabox(RegBuff);
                    // Format: LEXYZ/n 
                break;
            }
            RegBuff = "";
        }      
    }
}


void WriteCEC(char Port, char data)
{  
    char SendByte[2];
    SendByte[0] = '\x01';
    SendByte[1] = data;
    I2CBus.start(); // Not sure if this is required.
    I2CBus.write(Port, SendByte, 2);   
    I2CBus.stop(); 
}
char ReadCEC(char Port)
{
    char TempRead[1]; 
    char RegAddress = '\x01';
    I2CBus.start(); // Not sure if this is required.
    I2CBus.write(Port, &RegAddress, 1); //
    I2CBus.read(Port, TempRead, 1);
    I2CBus.stop();
    
    printf("CEC value is %d: \r\n",TempRead);
      
    return TempRead[0];
}
void ReadEthernet(char Register)
{
    char TempRead[10]; 
    I2CBus.start();
    I2CBus.write(EthAddWrite, &Register, 1); //
    I2CBus.read(EthAddRead, TempRead, 1);
    I2CBus.stop();
    
    printf("Ethernet Register %d: \r\n",Register);
    printf("Value is %d: \r\n",TempRead);
}


void CheckaboxData()
{ 
    string bufchar;
    string TempString;
    
    char inChar;
    while(aboxPort.readable()) 
    {
        inChar = aboxPort.getc(); // get the new byte
        InString1 += inChar; // add it to the inputString:
            
        if (inChar == '\n') 
        {
            TempString = InString1;
            InString1 = "";
            Processabox(TempString);
        }
    } 
}
void Processabox(string InString)
{
    // Format: LEXXYYZZ/n where LE is the comand type, X is interface ID, Y is LED number and Z is the LED state. XYZ are hex 
    
    uint8_t BoxNo = ((InString[2] - 48)*10) + (InString[3] - 48); // convert from 2 char bytes to 1 byte number
    uint8_t LEDNo = ((InString[4] - 48)*10) + (InString[5] - 48); 
    uint8_t LEDState = ((InString[6] - 48)*10) + (InString[7] - 48); 
      
    switch (InString[0])
    {
        case'L': SetLEDs(LEDNo, LEDState); break;
        case'H':   
            if (InString[1] == 'B')
                aboxPort.printf("HNTB\n");
                //Send heartbeat
        break;
        case'M':
            if (InString[1] == 'A')
            {
                
                           
            }
        case'U': // Update current status. 
            if (HDMI1Sync)
                aboxPort.printf("DSY%d11\n", IDNumber);
            else
                aboxPort.printf("DSY%d10\n", IDNumber);
            if (HDMI2Sync)
                aboxPort.printf("DSY%d21\n", IDNumber);
            else
                aboxPort.printf("DSY%d20\n", IDNumber);
            if (HDMI3Sync)
                aboxPort.printf("DSY%d31\n", IDNumber);
            else
                aboxPort.printf("DSY%d30\n", IDNumber);
            if (HDMI4Sync)
                aboxPort.printf("DSY%d41\n", IDNumber);
            else
                aboxPort.printf("DSY%d40\n", IDNumber);                 
        break;
        case'V': aboxPort.printf("REV%S\n", Revision.c_str()); break;
    }    
}
void SetLEDs(uint8_t LEDNo, uint8_t LEDState)
{
    printf("Set LEDs: LEDNo: %d LEDState: %d \n\r", LEDNo, LEDState );
    switch(LEDNo)
    {
        case 1: WriteCEC(Button1Address, (LEDNo * 10) + LEDState); break;
        case 2: WriteCEC(Button1Address, (LEDNo * 10) + LEDState); break;
        case 3: WriteCEC(Button1Address, (LEDNo * 10) + LEDState); break; 
        case 4: WriteCEC(Button1Address, (LEDNo * 10) + LEDState); break;      
    }
}

