/*
    Programmer: Roger McArdell
    Date: 04/08/2017
    
    For Texas Instraments TLV320ADC3101
    
    Versions 
    V0.1    First version
    
*/

static uint8_t DSPAddWrite = '\x30'; // 7 bit Address is \x18 + write bit = \x30
static uint8_t DSPAddRead = '\x31';  // 7 bit address is \x18 + read bit = \x31

// Prototypes



void ReadDSP(char Page, char RegAdd, uint8_t Bytes)
{
    char TempRead[Bytes]; 
    char TempWrite[5];
    
    TempWrite[0] = Page;
    TempWrite[1] = '\x0';
    
    I2CBus.start(); 
    2CBus.write(DSPAddWrite, &TempWrite, 2); // Select page N (Write data N to register 0 regardless of the current page number). assumed repeated-START condition is not required
    I2CBus.read(DSPAddRead, TempRead, Bytes); // Read or write data from/to valid registers in page N.   
    // Read or write data from/to valid registers in page N.   
    // Select new page M (Write data M to register 0 regardless of the current page number).
    // Read or write data from/to valid registers in page M.
    // Repeat as desired
    I2CBus.stop();
    
    pc.printf("DSP Register %d: \r\n",SlaveAdd);
    for (uint8_t I = 0; I < Bytes; I++)
    {
        pc.printf("Value is %d: \r\n",TempRead[I]);
    }   
}