#ifndef VGA640X400_H
#define VGA640X400_H

/**
 * @file vga640x400.h
 * Generate a 640x400 VGA signal.
 *
 * The following mbed pins are used:
 * - DIP5 - Monochrome bitstream (connect to R, G and B through 470R resistors)
 * - DIP8 - VSYNC
 * - DIP25 - HSYNC
 * - GND
 */
 
extern unsigned char text_buffer[80*25]; ///< 80x25 screen buffer, i.e. 25 lines of 80 characters.
extern unsigned char *font;              ///< Pointer to the user supplied font.
                                         ///< Each character is 8 pixels wide and 16 pixels high.
                                         ///< The font consists of 16 groups of 256 bytes.
                                         ///< i.e. 256 times the first byte of each character, then
                                         ///< 256 times the second byte of each character, and so on.
                                         ///< This differs from the most common way bitmap fonts are
                                         ///< ordered, so you have to preprocess your font data first.
                                    

/** Initialize the VGA signal
 *
 * This function should be the very first thing you call, before doing anything else.
 * It turns off all peripherals, sets the main clock to 100MHz (instead of the 96MHz default of the mbed)
 * and switches on PWM, I2S and DMA.
 */
void init_vga(void);

#endif