#include "kernel.h"
#include <mbed.h>

static void task_zero(void);
static void task_one(void);
static void task_two(void);
static void task_three(void);

struct ou_task ou_tasks[] = {
    { task_zero,  2, 0, 0, 0, NULL },
    { task_one,   1, 0, 0, 0, NULL },
    { task_two,   5, 0, 0, 0, NULL },
    { task_three, 5, 0, 0, 0, NULL }
};

const unsigned ou_ntasks = sizeof(ou_tasks)/sizeof(struct ou_task);


OU_TASK(task_zero)
    static DigitalOut led(LED1);

    OU_WAIT(100);
    led = 1;
    OU_WAIT(100);
    led = 0;
OU_ENDTASK

OU_TASK(task_one)
    static DigitalOut led(LED2);

    OU_WAIT(100);
    led = 1;
    OU_WAIT(100);
    led = 0;
    OU_WAIT(100);
    led = 1;
    for(;;) {
        OU_WAIT(50);
        led = 0;
        OU_WAIT(50);
        led = 1;
    }
OU_ENDTASK

OU_TASK(task_two)
    static DigitalOut led(LED3);
    for(;;) {
        OU_WAIT(100);
        led = !led;
    }
OU_ENDTASK

OU_TASK(task_three)
    static DigitalOut led(LED4);
    for(;;) {
        OU_WAIT(20);
        led = !led;
    }
OU_ENDTASK
