/* Opus Una - A Small Cooperative Multitasking Kernel in C
 *
 * Copyright (C) 2011 by Ivo van Poorten <ivop@euronet.nl>
 * This file is licensed under the terms of the GNU Lesser
 * General Public License, version 3.
 */

/* Run the kernel as a process on Unix */

#include "timer.h"
#include "kernel.h"

#include <sys/time.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

static void timer_sr(int x) {
    ou_ticks++;
    ou_update_tasks();
}

void ou_start_timer(void) {
    struct itimerval val;
    struct sigaction act;

    memset(&act, 0, sizeof(act));

    act.sa_handler = timer_sr;
    sigaction(SIGALRM, &act, NULL);     // signal() is not portable

    val.it_interval.tv_usec = 10000;    // 10ms
    val.it_interval.tv_sec = 0;
    val.it_value.tv_usec = 10000;       // 10ms
    val.it_value.tv_sec = 0; 
    setitimer(ITIMER_REAL, &val, NULL);
}

void ou_idle(void) {
    usleep(5);                  // save power/cpu time/et cetera...
}
