/* Opus Una - A Small Cooperative Multitasking Kernel in C
 *
 * Copyright (C) 2011 by Ivo van Poorten <ivop@euronet.nl>
 * This file is licensed under the terms of the GNU Lesser
 * General Public License, version 3.
 */

#include "timer.h"
#include "kernel.h"
#include "fastlib/systick.h"

extern "C" void SysTick_Handler(void) __irq {
    ou_ticks++;
    ou_update_tasks();
}

void ou_start_timer(void) {
    fl_systick_set_reload_value((96000000/100)-1);          // 1/100th of a second (10ms)
    fl_systick_control(FL_ENABLE, FL_ENABLE, FL_ENABLE);    // timer, irq, use cclk 
}

void ou_idle(void) {
    // save power/cpu time/et cetera...
}
