#include "main.h" //headfile


//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3); // connected the LED to the K64F board
DigitalIn button(PTB18);                // pin of the button connection
DigitalIn joystickbutton(PTB11);        // pin of the joystickbutton connection
AnalogIn xPot(PTB2);                    //pin of the joystick x point connection
AnalogIn yPot(PTB3);                    //pin of the joystick y point connection

// timer to regularly read the joystick
Ticker pollJoystick;

// Serial for debug
Serial pc(USBTX,USBRX);
// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

int main()
{
    button.mode(PullDown);           //let the button pressed equal to one
    joystickbutton.mode(PullDown);   //let the joystickbutton pressed equal to one
    lcd.init();
    // these are default settings so not strictly needed
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.5); // put LED backlight on 50%
    lcd.printString("get the ball",0,0); //write the string on the screen
    lcd.refresh();              //Refresh display        
    wait(1.0);                  //set the disappear time is 1s
    lcd.clear();            // clear display
    lcd.setBrightness(1.0);   // put LED backlight on 50%
    illustration ();       // function call
    int t=3;            //initial constant to quit the loop
    do
    {
        lcd.drawRect(0,0,84,48,2);  //draw rectangle picture
        lcd.drawRect(0,0,10,48,1);
        lcd.refresh();
        wait(0.5);              //0.5s to disappear
        lcd.clear();        
        if(button)              //check the button is pressed or not
        {
            lcd.clear();
            lcd.printString("Skip",0,0);  //write the string which will lose in 1s
            lcd.refresh();   
            wait(1.0);  
            lcd.clear();
            break;       //get out of the loop
        }
        moving ();    //function call
        t--;            //t=t-1
    }while(t>=0);       //when t=-1 jump outof the loop
    //write string lost in 1s
    lcd.printString("Warning:",0,0);      
    lcd.printString("The practice",0,0);
    lcd.printString("is finished",0,2);
    lcd.refresh();
    wait(1.0);
    lcd.clear();
    while (1)
    {
        srand(time(NULL));   //let the value achieved changes each time
        int u = rand()%(2-1+1)+1;     //get random value between 1 and 2
        //draw the picture disappears in 0.5s
        lcd.drawRect(0,0,84,48,2);
        lcd.drawRect(0,0,10,48,1);
        lcd.refresh();
        wait(0.5);
        lcd.clear();
        moving2();   //function call
        if(r==0)  //get global constant r
        {
        if (q>=10)    //use the if statement to judge the statement
        {   
            if(u==1)
            {
                lcd.clear();
                lcd.printString("Hold joystick",0,2);
                wait(2.0);
                lcd.clear();
                if (joystickbutton)  // check the joystickbutton is pressed or not
                    q=q-5;     //if it is ture, the global constant will reduce five each time
            }
        }
        else if (q<10)                //check the value of q
        {
            lcd.clear(); 
            lcd.printString("Congratulation",0,2);    //write string   
            lcd.refresh();
            break;                   //jump out of the loop
        }
        }
        else
        {
            lcd.clear();       
            lcd.printString("lose the game",0,2);   //write string  
            lcd.refresh();
            break;                      //jump out of the loop
        }
    } 
}
// the function to show the basic information of the game
void  illustration ()
{
    //show how to control the people
    lcd.printString("joystick to",0,0);
    lcd.printString("control people",0,1);
    //draw circle and draw line to built a people
    lcd.drawCircle(x,y,2,1);
    lcd.drawLine(x,y+2,x,y+7,1);
    lcd.drawLine(x,y+4,x+3,y+4,1);
    lcd.drawLine(x,y+7,x-2,y+9,1);
    lcd.drawLine(x,y+7,x+2,y+9,1);
    lcd.refresh();
    wait(3.0);
    lcd.clear();
    //show the way to win
    lcd.printString("Use hand to",0,0);
    lcd.printString("get the ball",0,1);
    lcd.drawCircle(20,23,2,1);
    lcd.drawCircle(25,27,1,1);
    lcd.drawCircle(40,27,1,1);
    lcd.drawLine(20,25,20,30,1);
    lcd.drawLine(20,27,23,27,1);
    lcd.drawLine(20,30,18,32,1);
    lcd.drawLine(20,30,22,32,1);
    lcd.refresh();
    wait(3.0);
    lcd.clear();
    //show the condition of the failure
    lcd.printString("if the ball",0,0);
    lcd.printString("touch the wall",0,1);
    lcd.printString("will lose",0,2);
    lcd.drawRect(0,30,10,20,1);
    lcd.drawCircle(15,40,1,1);
    lcd.refresh();
    wait(3.0);
    lcd.clear();
    //get into the game
    lcd.printString("practice",0,0);
    lcd.printString("Hold button",0,1);
    lcd.printString("to skip",0,3);
    lcd.refresh();
    wait(2.0);
    lcd.clear();
}
// use function to find the randon value of the ball x coordinate from 70 to 80
int setpointx (int x1)
{
    srand(time(NULL));   
    x1 = rand()%(80-70+1)+70;
    return x1;                  //return an integer to transfer the value to the other function
}
// use function to find the randon value of the enemy y coordinate from 15 to 30
int setpointy (int y1)
{
    srand(time(NULL));
    y1 = rand()%(30-15+1)+15;
    return y1;                  //return an integer to transfer the value to the other function
}

void moving ()
{
    //get the value of the x coordinate and y coordinate of the ball point
    int a,b;
    int a1=setpointx(a);
    int b1=setpointy(b);
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,0.5);  // read joystick 10 times per second
    while(1){
        //draw picture                   
        lcd.drawRect(0,0,84,48,2);
        lcd.drawRect(0,0,10,48,1);
        lcd.drawCircle(a1,b1,1,1);
        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
            pc.printf("x = %f y = %f button = %d ",joystick.x,joystick.y,joystick.button);
            // check joystick direction
            if (joystick.direction == UP) 
            {
                if(y>10)                         //use the if statement to make the border of the people moving
                {
                    //delete the old picture
                    lcd.drawCircle(x,y,2,2);       
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    // get the new picture
                    y=y-1;                       //change he value of the y coordinate
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {
                    // out of the border, just stay
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == DOWN) 
            {
                //the same use of the first one:joystick.direction == UP
                if(y<40)
                {                                   
                lcd.drawCircle(x,y,2,2);
                lcd.drawLine(x,y+2,x,y+7,2);
                lcd.drawLine(x,y+4,x+3,y+4,2);
                lcd.drawLine(x,y+7,x-2,y+9,2);
                lcd.drawLine(x,y+7,x+2,y+9,2);
                y=y+1;
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                    
            }
            if (joystick.direction == LEFT) {//the same use of the first one:joystick.direction == UP
                if(x<60)
                {
                    lcd.drawCircle(x,y,2,2);
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    x=x+1;
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == RIGHT) {//the same use of the first one:joystick.direction == UP
               if(x>q+5)
                {
                    lcd.drawCircle(x,y,2,2);
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    x=x-1;
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == CENTRE) {//no changing while the direction in centre, so just stay
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
            }
            if (joystick.direction == UNKNOWN) {//no changing while the direction unknown, so just stay
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
            }
        }
        //use if-else if statement to recognise the different situation
        if ((a1>=10)&&((a1!=x+3)||(b1!=y+4))) {//if the ball don't touch, then keep moving
            lcd.drawCircle(a1,b1,1,2);
            a1--;
        } else if ((a1==x+3) && (b1==y+4) && (a1>=10)) { // if the ball touch the people hand,stop moving and  
            lcd.clear();                                   // get out of the loop, and get a new ball
            break;
        } else if (a1<=10) {                        // if the ball touch the block, then show sentence to tell the player and 
            lcd.clear();                                // get out of the loop, and get a new ball
            lcd.printString("lose the game",0,0);
            lcd.refresh();
            wait(2.0);
            break;
        }
    wait(0.5);
    } 
}

void moving2 ()
{
    //same use of the function moving
    int a,b;
    int a1=setpointx(a);
    int b1=setpointy(b);
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,0.5);  // read joystick 10 times per second
    while(1) 
    {
        lcd.drawRect(0,0,84,48,2);
        lcd.drawRect(0,0,q,48,1);
        lcd.drawLine(50,0,50,48,1);
        lcd.drawCircle(a1,b1,1,1);
        lcd.refresh();
        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
            pc.printf("x = %f y = %f button = %d ",joystick.x,joystick.y,joystick.button);
            // check joystick direction
            if (joystick.direction == UP) // the same way to draw the prople and the principle of the people moving
            {
                if(y>10)
                {
                    lcd.drawCircle(x,y,2,2);
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    y=y-1;
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == DOWN) 
            {                         // same as the function moving
                if(y<40)
                {
                lcd.drawCircle(x,y,2,2);
                lcd.drawLine(x,y+2,x,y+7,2);
                lcd.drawLine(x,y+4,x+3,y+4,2);
                lcd.drawLine(x,y+7,x-2,y+9,2);
                lcd.drawLine(x,y+7,x+2,y+9,2);
                y=y+1;
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                    
            }
            if (joystick.direction == LEFT) {
                if(x<75)
                {                       // same as the function moving
                    lcd.drawCircle(x,y,2,2);
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    x=x+1;
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == RIGHT) {
               if(x>50)
                {                       // same as the function moving
                    lcd.drawCircle(x,y,2,2);
                    lcd.drawLine(x,y+2,x,y+7,2);
                    lcd.drawLine(x,y+4,x+3,y+4,2);
                    lcd.drawLine(x,y+7,x-2,y+9,2);
                    lcd.drawLine(x,y+7,x+2,y+9,2);
                    x=x-1;
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
                else
                {   
                    lcd.drawCircle(x,y,2,1);
                    lcd.drawLine(x,y+2,x,y+7,1);
                    lcd.drawLine(x,y+4,x+3,y+4,1);
                    lcd.drawLine(x,y+7,x-2,y+9,1);
                    lcd.drawLine(x,y+7,x+2,y+9,1);
                    lcd.refresh();
                }
            }
            if (joystick.direction == CENTRE) 
            {                           // same as the function moving
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
            }
            if (joystick.direction == UNKNOWN) 
            {                               // same as the function moving
                lcd.drawCircle(x,y,2,1);
                lcd.drawLine(x,y+2,x,y+7,1);
                lcd.drawLine(x,y+4,x+3,y+4,1);
                lcd.drawLine(x,y+7,x-2,y+9,1);
                lcd.drawLine(x,y+7,x+2,y+9,1);
                lcd.refresh();
            }
        }
        if ((a1>50)&&((a1!=x+3)||(b1!=y+4))) {// same as the function moving
            lcd.drawCircle(a1,b1,1,2);
            a1--;
        } else if ((a1==x+3) && (b1==y+4) && (a1>=10)) { // same as the function moving
            lcd.clear();
            break;
        } else if (a1<=50) {
            lcd.clear();
            r=1;                       // set global constant r=1 to jump the while(1) loop in the int main function
            wait(2.0);
            break;
        }
    wait(0.5);
    } 
}
// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}





