#if defined(TARGET_LPC11UXX) | defined(TARGET_LPC11U6X)
 
#ifndef IAP_LPC11UXX_H
#define IAP_LPC11UXX_H
 
#include "mbed.h"
 
//128-bit unique ID struct typedef
struct UID {
    unsigned int word0; /**< Word 0 of 128-bit UID (bits 31 to 0) */
    unsigned int word1; /**< Word 1 of 128-bit UID (bits 63 to 32) */
    unsigned int word2; /**< Word 2 of 128-bit UID (bits 95 to 64) */
    unsigned int word3; /**< Word 3 of 128-bit UID (bits 127 to 96) */
};
 
//IAP return code enumeration
enum IapReturnCode {
    IAP_CMD_SUCCESS = 0,
    IAP_INVALID_COMMAND,
    IAP_SRC_ADDR_ERROR,
    IAP_DST_ADDR_ERROR,
    IAP_SRC_ADDR_NOT_MAPPED,
    IAP_DST_ADDR_NOT_MAPPED,
    IAP_COUNT_ERROR,
    IAP_INVALID_SECTOR,
    IAP_SECTOR_NOT_BLANK,
    IAP_SECTOR_NOT_PREPARED_FOR_WRITE_OPERATION,
    IAP_COMPARE_ERROR,
    IAP_BUSY
};
 
//Function prototypes
IapReturnCode IAP_PrepareSectors(unsigned int sector_start, unsigned int sector_end);
IapReturnCode IAP_CopyRAMToFlash(void* ram_address, void* flash_address, unsigned int length);
IapReturnCode IAP_EraseSectors(unsigned int sector_start, unsigned int sector_end);
IapReturnCode IAP_BlankCheckSectors(unsigned int sector_start, unsigned int sector_end);
unsigned int IAP_ReadPartID();
unsigned short IAP_ReadBootCodeVersion();
IapReturnCode IAP_Compare(void* address1, void* address2, unsigned int bytes);
void IAP_ReinvokeISP();
UID IAP_ReadUID();
IapReturnCode IAP_ErasePage(unsigned int page_start, unsigned int page_end);
IapReturnCode IAP_WriteEEPROM(unsigned int ee_address, char* buffer, unsigned int length);
IapReturnCode IAP_ReadEEPROM(unsigned int ee_address, char* buffer, unsigned int length);
 
#endif
 
#endif