/*  Librairie de gestion de la carte SD d'un DMD RGB 128x32 pixels
*   - 256 Couleurs mode RGB332 et Monochrome -
*   decembre 2017 par Christophe Girardot Aka Aganyte
*/

#define SPI_CLOCK_HZ    ( 40 * 1000000 ) // Vitesse de communication SPI 40 MHz

SDFileSystem sd(MOSI, MISO, SCLK, CS, "sd", SPI_CLOCK_HZ); // Ouverture de la liaison SPI

FileHandle* file;   // Création d'un objet pour la gestion du fichier de donnée
FileHandle* Index;  // Création d'un objet pour la gestion du fichier d'index

char FileName[13];      // Stockage du nom du fichier actuellement en cours de lecture 8 Caractères + ".BIN" + "\0"
char Character[1];      // Stockage d'un caractère (doit être un tableau)
char Line_Buffer[17];   // Stockage d'une ligne de 16 caractères + "\0"

/* Fonction qui vide une chaine de caractère
*
*/
void Flush_ascii_buffer(char *buffer)
{
    unsigned int count = 0;
    while(buffer[count] != 0)
    {
        buffer[count]=0;
        count++;
    }
}

/* Fonction de lecture d'un fichier de donnée (les données lues son placées dans le buffer donné en argument)
*  Le nombre de kilo-octet à lire est donné en argument 
*  Renvois le nombre de caractères lu, 0 si rien à lire
*/
unsigned int readKB(unsigned char *Destination, unsigned char KB)
{
    unsigned int readed = 0; 
    readed = file->read(Destination, KB*1024);   
    return(readed);
}

/* Fonction qui recherche un caractère dans le fichier index.txt
*  ou revient au début si fin du fichier
*/
void Search_Char(char ThisChar)
{
    char Char[1];
    if(Index==NULL)
        Index = sd.open("index.TXT", O_RDONLY); // Si besoin, première ouverture du fichier index
    while( Char[0] != ThisChar ) // Chercher le signe =
    {
        Index->read(Char, 1); // lire un caractère
        if(Char[0] == '#')// si fin de fichier
        {
            pc.printf("Fin du fichier index.txt\n");
            delete Index; // Fermer le fichier
            Index = sd.open("index.TXT", O_RDONLY); // ré-ouvrir le fichier index
        }
    }
}

/* Fonction qui cherche et lit un nombre après un symbole donné
*  ne change pas la valeur si trouve rien
*/
char Search_Read_Char(char ThisChar, char Result) // Result => valeur d'origine
{
    char Buffer[1];
    Search_Char(ThisChar);  // lire jusqu'au prochain caractère donné
    Index->read(Buffer, 1); // Lire le nombre
    if( (Buffer[0]-'0' >= 0) & (Buffer[0]-'0' <= 9) ) //Accépter seulement les nombres de 0 à 9
        return (Buffer[0]-'0'); // renvoyer le nouveau nombre
    else
    {
        pc.printf("Erreur sur ce parametre : %d\n",Buffer[0]-'0');
        return(Result); // ou renvoyer l'ancien
    }
}

/* Fonction qui lit le fichier timestamp.txt
*/
void Read_Timestamp()
{
    unsigned char try_read = 0;
    FileHandle* Timestamp;
    while(1)
    {
        Timestamp = sd.open("time.TXT", O_RDONLY); // ouverture du fichier timestamp.TXT
        if(Timestamp != NULL)
        {
            pc.printf("Fichier time.txt ouvert\n");
            break; // Si le fichier est bien ouvert, quitter
        }
        try_read++;
        if(try_read > 10) { // Si le fichier n'est pas ouvert après 10 tentative quitter
            pc.printf("Plus de 10 tentatives de lecture du fichier -> probleme sur le fichier time.txt\n");
            break;
        }
    }

    Timestamp->read(Line_Buffer, 10); // lire 16 caractères
    Actual_timestamp = atol(Line_Buffer) + 3600; // Convertion de la valeur de Ascii vers un entier et rajouter une heure pour la France
    pc.printf("lecture de %d dans le fichier time.TXT\n",Actual_timestamp);
    Flush_ascii_buffer(Line_Buffer); // Vider le tampon
    delete Timestamp; // Fermer le fichier
}

/* Fonction d'ouverture d'un fichier sur la carte SD
*  avec 10 tentatives de lecture avant de déclarer un problème
*/
void Try_Open_File()
{
    unsigned char try_read = 0;
    while(1) 
    {
        delete file; // effacer l'objet file
        file = sd.open(FileName, O_RDONLY);
        if(file != NULL)
            break; // Si le fichier est bien ouvert, quitter
        try_read++;
        if(try_read > 10) // Si le fichier n'est pas ouvert après 10 tentative quitter
        {
            pc.printf("Plus de 10 tentatives de lecture du fichier -> probleme sur le fichier\n");
            break;
        }
    }
}

/* Fonction de lecture d'une animation présente sur la carte SD
*  Attention, le nom du fichier à lire doit déjà être en mémoire
*/
void Animation_SD()
{   
    for(unsigned char count = 0; count < Replay; count++) // Jouer l'animation en fonction du nombre de répétition
    {
        Try_Open_File();    // Essayer d'ouvrir le fichier
        while(1) 
        {
            // lecture d'une trame avec détection de la fin de l'animation
            if(readKB(Display_Ram,4) == 0) 
                break;
            // Affichage de la trame avec gestion de la vitesse
            for(unsigned char count = 0; count < (10-Speed); count++)
                refresh();
        }
    }
    pc.printf("fin de l'animation %s\n\n",FileName);
}

/* Fonction de lecture d'une commande d'animation dans le fichier Index.txt
*
*  Exemple d'utilisation:
*
*  >Animation FileName=test0000.BIN Repeat=2 Speed=8
*/
void Read_Animation()
{
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(FileName, 12); // lire le nom de fichier

    Replay = Search_Read_Char('=',Replay);
    
    Speed = Search_Read_Char('=',Speed);
    
    // affichage dans la console
    pc.printf("Lecture de %s\n",FileName);
    pc.printf("Nombre de repetition du fichier : %d\n",Replay);
    pc.printf("Vitesse de lecture : %d\n",Speed);
    
    Animation_SD(); // Lancer l'animation
}

/* Fonction de lecture d'une commande Image dans le fichier Index.txt
*
*  Exemple d'utilisation:
*
*  >Animation FileName=test0000.BIN time=2
*/
void Image_SD()
{
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(FileName, 12); // lire le nom de fichier

    Sleep = Search_Read_Char('=',Sleep);

    // affichage dans la console
    pc.printf("Affichage de l'image %s pendant %d secondes\n\n",FileName,Sleep);
 
    Try_Open_File();    // Essayer d'ouvrir le fichier
    
    readKB(Display_Ram,4); // Charger une trame dans la mémoire vidéo RGB
    
    Image(Sleep); // Afficher l'image
}

/* Fonction de lecture d'une commande de texte dans le fichier Index.txt
*
*  Exemple d'utilisation:
*
*  >Write Temp=5 L1=XXXXXXXXXXXXXXXX L2=XXXXXXXXXXXXXXXX L3=XXXXXXXXXXXXXXXX L4=XXXXXXXXXXXXXXXX
*/
void Read_Text()
{    
    Sleep = Search_Read_Char('=',Sleep);
 
    pc.printf("Affichage d'un texte pendant %d secondes\n",Sleep); // affichage dans la console
 
    // Placer les 4 lignes dans le buffer vidéo monochrome
    for(unsigned char count = 1; count<5; count++)
    {
        Search_Char('='); // lire jusqu'au prochain =
        Index->read(Line_Buffer, 16); // lire la ligne
        print_4_16(Line_Buffer,count); // Ecrire la ligne dans le buffer vidéo monochrome
        pc.printf("Ligne %d = %s\n",count,Line_Buffer); // affichage dans la console
    }
    pc.printf("\n");
    Refresh_in_seconds();  // Rafraichir l'écran pendant x secondes
}

/* Fonction de lecture d'une commande qui superpose une image et du texte dans le fichier Index.txt
*
*  Exemple d'utilisation:
*
*  >Score FileName=test0000.BIN Temp=5 L1=XXXXXXXXXXXXXXXX L2=XXXXXXXXXXXXXXXX L3=XXXXXXXXXXXXXXXX L4=XXXXXXXXXXXXXXXX
*/
void Score_SD()
{
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(FileName, 12); // lire le nom de fichier
    
    Sleep = Search_Read_Char('=',Sleep);

    pc.printf("Affichage d'un score pendant %d secondes\n",Sleep); // affichage dans la console
 
    // Placer les 4 lignes dans le buffer vidéo monochrome
    for(unsigned char count = 1; count<5; count++)
    {
        Search_Char('='); // lire jusqu'au prochain =
        Index->read(Line_Buffer, 16); // lire la ligne
        print_4_16(Line_Buffer,count); // Ecrire la ligne dans le buffer vidéo monochrome
        pc.printf("Ligne %d = %s\n",count,Line_Buffer); // affichage dans la console
    }
    pc.printf("\n");
    Try_Open_File();    // Essayer d'ouvrir le fichier
    
    readKB(Display_Ram,4); // Charger une trame dans la mémoire vidéo RGB
    
    Convert_Bool_To_RGB(); // Convertir le buffer mono avec superposition dans le buffer couleur
    
    Image(Sleep); // Afficher l'image
}

/* Fonction de lecture d'une commande de réglage des couleurs
*
*  Exemple d'utilisation:
*
*  >SetColor R=1 G=0 B=0
*/
void Set_Color()
{
    Color_R = Search_Read_Char('=',Color_R);
    Color_B = Search_Read_Char('=',Color_G);
    Color_G = Search_Read_Char('=',Color_B);
    
    pc.printf("Reglages des couleurs du mode monochrome avec R=%d,G=%d,B=%d\n\n",Color_R,Color_G,Color_B); // affichage dans la console
}

/* Fonction de lecture d'une commande horloge
*
*  Exemple d'utilisation:
*
*  >Clock Temp=5
*/
void Read_Clock()
{
    Sleep = Search_Read_Char('=',Sleep);
    
    pc.printf("Affichage de l'heure pendant %d secondes\n\n",Sleep); // affichage dans la console
    
    Clock();
}

/* Fonction de lecture d'une commande temperature
*
*  Exemple d'utilisation:
*
*  >Temperature Temp=5
*/
void Read_Temperature()
{
    Sleep = Search_Read_Char('=',Sleep);
    
    pc.printf("Affichage de la temperature pendant %d secondes\n\n",Sleep); // affichage dans la console
    
    Temperature();
}

/* Fonction de lecture d'une commande lecture de la pile de backup
*
*  Exemple d'utilisation:
*
*  >Battery Temp=5
*/
void Read_Backup()
{
    Sleep = Search_Read_Char('=',Sleep);
    
    pc.printf("Affichage de la tension de la batterie pendant %d secondes\n\n",Sleep); // affichage dans la console
    
    Backup();
}
    
/* Fonction de lecture d'une commande de scrolling vertical dans le fichier Index.txt
*  ATTENTION => La hauteur est à remplir sur 3 digits (max 320 pixels de haut)
*  Exemple d'utilisation:
*
*  >Vertical FileName=test0000.BIN height=128 Speed=8 Up=1
*/
void Vertical_Scrolling_SD()
{
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(FileName, 12); // lire le nom de fichier
    
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(Line_Buffer, 3); // lire 16 caractères
    unsigned int height = atoi(Line_Buffer); // Convertion de la valeur de Ascii vers un entier

    Speed = Search_Read_Char('=',Speed);
    
    Up = Search_Read_Char('=',Up);
    
    Try_Open_File(); // Ouvrir le fichier
    
    readKB(Scrolling_Buffer,40); // Charger le scrolling dans la mémoire
    
    pc.printf("Affichage du scrolling vertical %s de 128x%d pixels depuis la carte SD a la vitesse de %d avec Up=%d\n\n",FileName,height,Speed,Up);
    
    if(Up!=1)
    {
        for(unsigned char decal = 0; decal<(height-32); decal++) {
            // Remplir la mémoire vidéo avec une image
            for(unsigned int count = 0; count<4096; count++)
                Display_Ram[count] = Scrolling_Buffer[(decal*128)+count];
            // Affichage de la trame avec gestion de la vitesse
            for(unsigned char count = 0; count < (10-Speed); count++)
                refresh();
        }
    }
    else
    {
        for(unsigned char decal = (height-32); decal!=0; decal--) {
            // Remplir la mémoire vidéo avec une image
            for(unsigned int count = 0; count<4096; count++)
                Display_Ram[count] = Scrolling_Buffer[(decal*128)+count];
            // Affichage de la trame avec gestion de la vitesse
            for(unsigned char count = 0; count < (10-Speed); count++)
                refresh();
        }
    }
    Flush_ascii_buffer(Line_Buffer);
}

/* Fonction de lecture d'une commande de scrolling horizontal dans le fichier Index.txt
*  ATTENTION => La hauteur est à remplir sur 4 digits (max 1280 pixels de large)
*  Exemple d'utilisation:
*
*  >Horizontal FileName=test0000.BIN height=0128 Speed=8
*/
void Horizontal_Scrolling_SD()
{
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(FileName, 12); // lire le nom de fichier
    
    Search_Char('='); // lire jusqu'au prochain =
    Index->read(Line_Buffer, 4); // lire 16 caractères
    unsigned int width = atoi(Line_Buffer); // Convertion de la valeur de Ascii vers un entier

    Speed = Search_Read_Char('=',Speed);

    Left = Search_Read_Char('=',Left);

    Try_Open_File(); // Ouvrir le fichier
    
    readKB(Scrolling_Buffer,40); // Charger le scrolling dans la mémoire
    
    pc.printf("Affichage du scrolling horizontal %s de %dx32 pixels depuis la carte SD a la vitesse de %d avec Left=%d\n\n",FileName,width,Speed,Left);
    
    if(Left==1)
    {
        for(unsigned int image = 0 ; image < width-128; image++) {
            // Remplir la mémoire vidéo avec une ligne
            for(unsigned char ligne = 0; ligne<32; ligne++) {
                for(unsigned char count = 0 ; count<128 ; count++)
                    Display_Ram[count+(ligne*128)] = Scrolling_Buffer[image+count+(width*ligne)];
            }
            // Affichage de la trame avec gestion de la vitesse
            for(unsigned char count = 0; count < (10-Speed); count++)
                refresh();
        }
    }
    else
    {
        for(unsigned int image = width-128 ; image !=0 ; image--) {
            // Remplir la mémoire vidéo avec une ligne
            for(unsigned char ligne = 0; ligne<32; ligne++) {
                for(unsigned char count = 0 ; count<128 ; count++)
                    Display_Ram[count+(ligne*128)] = Scrolling_Buffer[image+count+(width*ligne)];
            }
            // Affichage de la trame avec gestion de la vitesse
            for(unsigned char count = 0; count < (10-Speed); count++)
                refresh();
        }
    }
    Flush_ascii_buffer(Line_Buffer);
}

/*  Fonction de réglage du brightness (de 0 à 9)
*   Exemple: Brightness=5
*/
void Set_Brightness()
{
    Brightness_level = Search_Read_Char('=',Brightness_level); // Lire le brightness souhaité
    
    pc.printf("Reglages du niveau de brightness sur %d\n\n",Brightness_level); // affichage dans la console 

    Time_Shade[1] = Start_Time_Shade1 - Adjust_Brightness_shade1[Brightness_level] ;
    Time_Shade[2] = Start_Time_Shade2 - Adjust_Brightness_shade2[Brightness_level] ;
    Time_Shade[3] = Start_Time_Shade3 - Adjust_Brightness_shade3[Brightness_level] ;
    Time_Shade[4] = Start_Time_Shade4 - Adjust_Brightness_shade4[Brightness_level] ;
    Time_Shade[5] = Start_Time_Shade5 - Adjust_Brightness_shade5[Brightness_level] ;
    Time_Shade[6] = Start_Time_Shade6 - Adjust_Brightness_shade6[Brightness_level] ;
}

/* Lire et effectuer la prochaine commade du fichier index.txt */
void Read_Next_Command()
{
    Search_Char('>'); // Chercher le prochain début de commande
    Index->read(Command, 5); // lire la commande

    if( strcmp("Anima", Command) == 0)      // Animation
        Read_Animation();
    else if(strcmp("Write", Command) == 0) // Write
        Read_Text();
    else if(strcmp("Clock", Command) == 0)
        Read_Clock();       // Clock
    else if(strcmp("Tempe", Command) == 0)
        Read_Temperature(); // Temperature
    else if(strcmp("Backu", Command) == 0)
        Read_Backup();      // pile de Backup
    else if(strcmp("Setco", Command) == 0)
        Set_Color();        // changement des couleurs du mode monochrome
    else if(strcmp("Verti", Command) == 0)
        Vertical_Scrolling_SD(); // Scrolling vertical depuis la SD
    else if(strcmp("Horiz", Command) == 0)
        Horizontal_Scrolling_SD(); // Scrolling Horizontal depuis la SD
    else if(strcmp("Image", Command) == 0)
        Image_SD(); // Image depuis la SD
    else if(strcmp("Score", Command) == 0)
        Score_SD(); // Superposer une Image avec du texte depuis la SD (scores)
    else if(strcmp("Brigh", Command) == 0)
        Set_Brightness(); // Régler le niveau de brightness
    else
        pc.printf("Aucune Commande dans le fichier index.ini\n");
}
